﻿/* Copyright (c) Cloud Software Group, Inc. 
 * 
 * Redistribution and use in source and binary forms, 
 * with or without modification, are permitted provided 
 * that the following conditions are met: 
 * 
 * *   Redistributions of source code must retain the above 
 *     copyright notice, this list of conditions and the 
 *     following disclaimer. 
 * *   Redistributions in binary form must reproduce the above 
 *     copyright notice, this list of conditions and the 
 *     following disclaimer in the documentation and/or other 
 *     materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */

// ============================================================================
// Description:   Utilitiy functions built on top of libxen for use in all
//                providers.
// ============================================================================

// ------------------------------------------------------------------------------
//  <auto-generated>
//    Generated by Xsd2Code. Version 2.1.3177.19956
//   <NameSpace>OvfDefinitions</NameSpace><Collection>Array</Collection><codeType>CSharp</codeType><EnableDataBinding>False</EnableDataBinding><HidePrivateFieldInIDE>False</HidePrivateFieldInIDE><EnableSummaryComment>False</EnableSummaryComment>
//  <auto-generated>
// ------------------------------------------------------------------------------
namespace XenOvf.Definitions
{
    using System;
    using System.ComponentModel;
    using System.Diagnostics;
    using System.Xml.Schema;
    using System.Xml.Serialization;

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    [System.Xml.Serialization.XmlRootAttribute("Envelope", Namespace = "http://schemas.dmtf.org/ovf/envelope/1", IsNullable = false)]
    public partial class EnvelopeType
    {
        [XmlAttribute(AttributeName = "xml:lang")]
        public string lang;

        private References_Type referencesField;

        private Section_Type[] itemsField;

        private Content_Type itemField;

        private Strings_Type[] stringsField;

        private System.Xml.XmlAttribute[] anyAttrField;


        #region ADDED BY CITRIX
        private string versionField;
        private string nameField;
        private string idField;

        [XmlAttribute(Namespace="http://schemas.citrix.com/ovf/envelope/1")]
        public string Name
        {
            get { return nameField; }
            set { nameField = value; }
        }

        [XmlAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
        public string id
        {
            get { return idField; }
            set { idField = value; }
        }

        [XmlAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
        public string version
        {
            get { return versionField; }
            set { versionField = value; }
        }

        #endregion

        /// <remarks/>
        public References_Type References
        {
            get
            {
                return this.referencesField;
            }
            set
            {
                this.referencesField = value;
            }
        }

        /// <remarks>Changed auto gen code from items to sections</remarks>
        [System.Xml.Serialization.XmlElementAttribute("AnnotationSection", typeof(AnnotationSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("DeploymentOptionSection", typeof(DeploymentOptionSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("DiskSection", typeof(DiskSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("EulaSection", typeof(EulaSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("InstallSection", typeof(InstallSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("NetworkSection", typeof(NetworkSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("OperatingSystemSection", typeof(OperatingSystemSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("ProductSection", typeof(ProductSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("ResourceAllocationSection", typeof(ResourceAllocationSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("Section", typeof(Section_Type))]
        [System.Xml.Serialization.XmlElementAttribute("StartupSection", typeof(StartupSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("VirtualHardwareSection", typeof(VirtualHardwareSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("SecuritySection", typeof(SecuritySection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("IpAssignmentSection", typeof(IpAssignmentSection_Type))]
        public Section_Type[] Sections
        {
            get
            {
                return this.itemsField;
            }
            set
            {
                this.itemsField = value;
            }
        }

        /// <remarks>Changed auto gen code from item to Content</remarks>
        [System.Xml.Serialization.XmlElementAttribute("Content", typeof(Content_Type))]
        [System.Xml.Serialization.XmlElementAttribute("VirtualSystem", typeof(VirtualSystem_Type))]
        [System.Xml.Serialization.XmlElementAttribute("VirtualSystemCollection", typeof(VirtualSystemCollection_Type))]
        public Content_Type Item
        {
            get
            {
                return this.itemField;
            }
            set
            {
                this.itemField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlElementAttribute("Strings")]
        public Strings_Type[] Strings
        {
            get
            {
                return this.stringsField;
            }
            set
            {
                this.stringsField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class References_Type
    {

        private File_Type[] fileField;
        private System.Xml.XmlElement[] anyField;
        private System.Xml.XmlAttribute[] anyAttrField;

        /// <remarks/>
        [System.Xml.Serialization.XmlElementAttribute("File")]
        public File_Type[] File
        {
            get
            {
                return this.fileField;
            }
            set
            {
                this.fileField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;
            }
            set
            {
                this.anyField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class File_Type
    {
        private System.Xml.XmlElement[] anyField;

        private string idField;

        private string hrefField;

        private ulong sizeField;

        private bool sizeFieldSpecified;

        private string compressionField;

        private long chunkSizeField;

        private bool chunkSizeFieldSpecified;

        private System.Xml.XmlAttribute[] anyAttrField;

        public File_Type()
        {
            this.compressionField = "";
        }

        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;
            }
            set
            {
                this.anyField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string id
        {
            get
            {
                return this.idField;
            }
            set
            {
                this.idField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified, DataType = "anyURI")]
        public string href
        {
            get
            {
                return this.hrefField;
            }
            set
            {
                this.hrefField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public ulong size
        {
            get
            {
                return this.sizeField;
            }
            set
            {
                this.sizeField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool sizeSpecified
        {
            get
            {
                return this.sizeFieldSpecified;
            }
            set
            {
                this.sizeFieldSpecified = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute("")]
        public string compression
        {
            get
            {
                return this.compressionField;
            }
            set
            {
                this.compressionField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public long chunkSize
        {
            get
            {
                return this.chunkSizeField;
            }
            set
            {
                this.chunkSizeField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool chunkSizeSpecified
        {
            get
            {
                return this.chunkSizeFieldSpecified;
            }
            set
            {
                this.chunkSizeFieldSpecified = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }

        #region CITRIX ADDED SECURITY
        private string wsuIdField;
        [System.Xml.Serialization.XmlAttributeAttribute(Namespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string Id
        {
            get
            {
                return wsuIdField;
            }
            set
            {
                wsuIdField = value;
            }
        }
        #endregion
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class Strings_Type
    {

        private Strings_TypeMsg[] msgField;

        private string langField;

        private string fileRefField;

        private System.Xml.XmlAttribute[] anyAttrField;

        /// <remarks/>
        [System.Xml.Serialization.XmlElementAttribute("Msg")]
        public Strings_TypeMsg[] Msg
        {
            get
            {
                return this.msgField;
            }
            set
            {
                this.msgField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified, Namespace = "http://www.w3.org/XML/1998/namespace")]
        public string lang
        {
            get
            {
                return this.langField;
            }
            set
            {
                this.langField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string fileRef
        {
            get
            {
                return this.fileRefField;
            }
            set
            {
                this.fileRefField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class Strings_TypeMsg
    {

        private string msgidField;

        private System.Xml.XmlAttribute[] anyAttrField;

        private string valueField;

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string msgid
        {
            get
            {
                return this.msgidField;
            }
            set
            {
                this.msgidField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlTextAttribute()]
        public string Value
        {
            get
            {
                return this.valueField;
            }
            set
            {
                this.valueField = value;
            }
        }
    }

    /// <remarks/>
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(VirtualSystemCollection_Type))]
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(VirtualSystem_Type))]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    [System.Xml.Serialization.XmlRootAttribute("Content", Namespace = "http://schemas.dmtf.org/ovf/envelope/1", IsNullable = false)]
    public abstract partial class Content_Type
    {

        private Msg_Type infoField;

        private Msg_Type[] nameField;

        private Section_Type[] itemsField;

        private string idField;

        private System.Xml.XmlAttribute[] anyAttrField;

        /// <remarks/>
        public Msg_Type Info
        {
            get
            {
                return this.infoField;
            }
            set
            {
                this.infoField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlElementAttribute("Name")]
        public Msg_Type[] Name
        {
            get
            {
                return this.nameField;
            }
            set
            {
                this.nameField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlElementAttribute("AnnotationSection", typeof(AnnotationSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("DeploymentOptionSection", typeof(DeploymentOptionSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("DiskSection", typeof(DiskSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("EulaSection", typeof(EulaSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("InstallSection", typeof(InstallSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("NetworkSection", typeof(NetworkSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("OperatingSystemSection", typeof(OperatingSystemSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("ProductSection", typeof(ProductSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("ResourceAllocationSection", typeof(ResourceAllocationSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("Section", typeof(Section_Type))]
        [System.Xml.Serialization.XmlElementAttribute("StartupSection", typeof(StartupSection_Type))]
        [System.Xml.Serialization.XmlElementAttribute("VirtualHardwareSection", typeof(VirtualHardwareSection_Type))]
        public Section_Type[] Items
        {
            get
            {
                return this.itemsField;
            }
            set
            {
                this.itemsField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string id
        {
            get
            {
                return this.idField;
            }
            set
            {
                this.idField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class Msg_Type
    {

        private string msgidField;

        private System.Xml.XmlAttribute[] anyAttrField;

        private string valueField;

        public Msg_Type()
        {
            this.msgidField = "";
        }

        public Msg_Type(string msgid, string value)
        {
            if (msgid != null)
            {
                this.msgidField = msgid;
            }
            this.valueField = value;
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute("")]
        public string msgid
        {
            get
            {
                return this.msgidField;
            }
            set
            {
                this.msgidField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlTextAttribute()]
        public string Value
        {
            get
            {
                return this.valueField;
            }
            set
            {
                this.valueField = value;
            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    [System.Xml.Serialization.XmlRootAttribute("AnnotationSection", Namespace = "http://schemas.dmtf.org/ovf/envelope/1", IsNullable = false)]
    public partial class AnnotationSection_Type : Section_Type
    {

        private Msg_Type annotationField;

        private System.Xml.XmlElement[] anyField;

        /// <remarks/>
        public Msg_Type Annotation
        {
            get
            {
                return this.annotationField;
            }
            set
            {
                this.annotationField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;


            }
            set
            {
                this.anyField = value;

            }
        }


    }

    /// <remarks/>
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(DeploymentOptionSection_Type))]
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(StartupSection_Type))]
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(InstallSection_Type))]
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(ResourceAllocationSection_Type))]
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(VirtualHardwareSection_Type))]
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(EulaSection_Type))]
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(OperatingSystemSection_Type))]
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(DiskSection_Type))]
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(NetworkSection_Type))]
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(ProductSection_Type))]
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(AnnotationSection_Type))]
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(IpAssignmentSection_Type))]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    [System.Xml.Serialization.XmlRootAttribute("Section", Namespace = "http://schemas.dmtf.org/ovf/envelope/1", IsNullable = false)]
    public abstract partial class Section_Type
    {

        private Msg_Type infoField;

        private bool requiredField;

        private bool requiredFieldSpecified;

        private System.Xml.XmlAttribute[] anyAttrField;

        public Section_Type()
        {
            this.requiredField = true;
        }

        /// <remarks/>
        public Msg_Type Info
        {
            get
            {
                return this.infoField;
            }
            set
            {
                this.infoField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool required
        {
            get
            {
                return this.requiredField;
            }
            set
            {
                this.requiredField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool requiredSpecified
        {
            get
            {
                return this.requiredFieldSpecified;
            }
            set
            {
                this.requiredFieldSpecified = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }
      
        #region CITRIX ADDED
        private string idField;
        [XmlAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
        public string Id
        {
            get { return idField; }
            set { idField = value; }
        }
        #endregion
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class DeploymentOptionSection_Type : Section_Type
    {

        private DeploymentOptionSection_TypeConfiguration[] configurationField;

        private System.Xml.XmlElement[] anyField;

        /// <remarks/>
        [System.Xml.Serialization.XmlElementAttribute("Configuration")]
        public DeploymentOptionSection_TypeConfiguration[] Configuration
        {
            get
            {
                return this.configurationField;
            }
            set
            {
                this.configurationField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;


            }
            set
            {
                this.anyField = value;

            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class DeploymentOptionSection_TypeConfiguration
    {

        private Msg_Type labelField;

        private Msg_Type descriptionField;

        private string idField;

        private bool defaultField;

        private System.Xml.XmlAttribute[] anyAttrField;

        public DeploymentOptionSection_TypeConfiguration()
        {
            this.defaultField = false;
        }

        /// <remarks/>
        public Msg_Type Label
        {
            get
            {
                return this.labelField;
            }
            set
            {
                this.labelField = value;
            }
        }

        /// <remarks/>
        public Msg_Type Description
        {
            get
            {
                return this.descriptionField;
            }
            set
            {
                this.descriptionField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string id
        {
            get
            {
                return this.idField;
            }
            set
            {
                this.idField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool @default
        {
            get
            {
                return this.defaultField;
            }
            set
            {
                this.defaultField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class StartupSection_Type : Section_Type
    {

        private StartupSection_TypeItem[] itemField;

        private System.Xml.XmlElement[] anyField;

        /// <remarks/>
        [System.Xml.Serialization.XmlElementAttribute("Item")]
        public StartupSection_TypeItem[] Item
        {
            get
            {
                return this.itemField;
            }
            set
            {
                this.itemField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;


            }
            set
            {
                this.anyField = value;

            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class StartupSection_TypeItem
    {

        private string idField;

        private long orderField;

        private long startDelayField;

        private bool waitingForGuestField;

        private long stopDelayField;

        private string startActionField;

        private string stopActionField;

        private System.Xml.XmlAttribute[] anyAttrField;

        public StartupSection_TypeItem()
        {
            this.startDelayField = ((ushort)(0));
            this.waitingForGuestField = false;
            this.stopDelayField = ((ushort)(0));
            this.startActionField = "powerOn";
            this.stopActionField = "powerOff";
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string id
        {
            get
            {
                return this.idField;
            }
            set
            {
                this.idField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public long order
        {
            get
            {
                return this.orderField;
            }
            set
            {
                this.orderField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute(typeof(long), "0")]
		public long startDelay
        {
            get
            {
                return this.startDelayField;
            }
            set
            {
                this.startDelayField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool waitingForGuest
        {
            get
            {
                return this.waitingForGuestField;
            }
            set
            {
                this.waitingForGuestField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute(typeof(long), "0")]
		public long stopDelay
        {
            get
            {
                return this.stopDelayField;
            }
            set
            {
                this.stopDelayField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute("powerOn")]
        public string startAction
        {
            get
            {
                return this.startActionField;
            }
            set
            {
                this.startActionField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute("powerOff")]
        public string stopAction
        {
            get
            {
                return this.stopActionField;
            }
            set
            {
                this.stopActionField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class InstallSection_Type : Section_Type
    {
        private System.Xml.XmlElement[] anyField;
        private ushort initialBootStopDelayField;

        public InstallSection_Type()
        {
            this.initialBootStopDelayField = ((ushort)(0));
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;



            }
            set
            {
                this.anyField = value;

            }
        }


        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute(typeof(ushort), "0")]
        public ushort initialBootStopDelay
        {
            get
            {
                return this.initialBootStopDelayField;
            }
            set
            {
                this.initialBootStopDelayField = value;
            }
        }

        #region CITRIX ADDED
        private Xen_PostInstallOperation_Type postInstallOperationsField;

        [XmlElement(Namespace = "http://schemas.citrix.com/ovf/envelope/1", Form = XmlSchemaForm.Qualified)]
        public Xen_PostInstallOperation_Type PostInstallOperations
        {
            get
            {
                return postInstallOperationsField;
            }
            set
            {
                postInstallOperationsField = value;
            }
        }
        #endregion

    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class ResourceAllocationSection_Type : Section_Type
    {

        private RASD_Type[] itemField;

        private System.Xml.XmlElement[] anyField;

        /// <remarks/>
        [System.Xml.Serialization.XmlElementAttribute("Item")]
        public RASD_Type[] Item
        {
            get
            {
                return this.itemField;
            }
            set
            {
                this.itemField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;


            }
            set
            {
                this.anyField = value;

            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class RASD_Type : CIM_ResourceAllocationSettingData_Type, IComparable
    {

        private bool requiredField;

        private string configurationField;

        private string boundField;

        private System.Xml.XmlAttribute[] anyAttr1Field;

        public RASD_Type()
        {
            this.requiredField = true;
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute(true)] // Changed between 1.0.0c and 1.0.0d.. changed back in 1.0.1
        public bool required
        {
            get
            {
                return this.requiredField;
            }
            set
            {
                this.requiredField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string configuration
        {
            get
            {
                return this.configurationField;
            }
            set
            {
                this.configurationField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string bound
        {
            get
            {
                return this.boundField;
            }
            set
            {
                this.boundField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr1
        {
            get
            {
                return this.anyAttr1Field;
            }
            set
            {
                this.anyAttr1Field = value;
            }
        }


        #region IComparable Members (ADDED By Cloud Software Group, Inc.)

        public int CompareTo(object obj)
        {
            if (obj is RASD_Type)
            {
                RASD_Type rasd = (RASD_Type)obj;
                if (this.ResourceType != null &&
                    rasd.ResourceType != null)
                {
                  
                    return (this.ResourceType.Value).CompareTo(rasd.ResourceType.Value);
                }
                else
                {
                    throw new ArgumentNullException("Cannot compare null values");
                }
            }
            else
            {
                throw new ArgumentException("object is not of type CIM_ResourceAllocationSettingData_Type");
            }
        }

        #endregion

    }

    /// <remarks/>
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(RASD_Type))]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData")]
    public partial class CIM_ResourceAllocationSettingData_Type
    {

        private cimString addressField;

        private cimString addressOnParentField;

        private cimString allocationUnitsField;

        private cimBoolean automaticAllocationField;

        private cimBoolean automaticDeallocationField;

        private Caption captionField;

        private ChangeableType changeableTypeField;

        private cimString configurationNameField;

        private cimString[] connectionField;

        private ConsumerVisibility consumerVisibilityField;

        private cimString descriptionField;

        private cimString elementNameField;

        private cimUnsignedLong generationField;

        private cimString[] hostResourceField;

        private cimString instanceIDField;

        private cimUnsignedLong limitField;

        private MappingBehavior mappingBehaviorField;

        private cimString otherResourceTypeField;

        private cimString parentField;

        private cimString poolIDField;

        private cimUnsignedLong reservationField;

        private cimString resourceSubTypeField;

        private ResourceType resourceTypeField;

        private cimUnsignedLong virtualQuantityField;

        private cimString virtualQuantityUnitsField;

        private cimUnsignedInt weightField;

        private System.Xml.XmlElement[] anyField;

        private System.Xml.XmlAttribute[] anyAttrField;

        /// <remarks/>
        [XmlElementAttribute]
        public cimString Address
        {
            get
            {
                return this.addressField;
            }
            set
            {
                this.addressField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString AddressOnParent
        {
            get
            {
                return this.addressOnParentField;
            }
            set
            {
                this.addressOnParentField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString AllocationUnits
        {
            get
            {
                return this.allocationUnitsField;
            }
            set
            {
                this.allocationUnitsField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimBoolean AutomaticAllocation
        {
            get
            {
                return this.automaticAllocationField;
            }
            set
            {
                this.automaticAllocationField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimBoolean AutomaticDeallocation
        {
            get
            {
                return this.automaticDeallocationField;
            }
            set
            {
                this.automaticDeallocationField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public Caption Caption
        {
            get
            {
                return this.captionField;
            }
            set
            {
                this.captionField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public ChangeableType ChangeableType
        {
            get
            {
                return this.changeableTypeField;
            }
            set
            {
                this.changeableTypeField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString ConfigurationName
        {
            get
            {
                return this.configurationNameField;
            }
            set
            {
                this.configurationNameField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute("Connection")]
        public cimString[] Connection
        {
            get
            {
                return this.connectionField;
            }
            set
            {
                this.connectionField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public ConsumerVisibility ConsumerVisibility
        {
            get
            {
                return this.consumerVisibilityField;
            }
            set
            {
                this.consumerVisibilityField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString Description
        {
            get
            {
                return this.descriptionField;
            }
            set
            {
                this.descriptionField = value;
            }
        }

        /// <remarks/>
        public cimString ElementName
        {
            get
            {
                return this.elementNameField;
            }
            set
            {
                this.elementNameField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimUnsignedLong Generation
        {
            get
            {
                return this.generationField;
            }
            set
            {
                this.generationField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute("HostResource")]
        public cimString[] HostResource
        {
            get
            {
                return this.hostResourceField;
            }
            set
            {
                this.hostResourceField = value;
            }
        }

        /// <remarks/>
        public cimString InstanceID
        {
            get
            {
                return this.instanceIDField;
            }
            set
            {
                this.instanceIDField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimUnsignedLong Limit
        {
            get
            {
                return this.limitField;
            }
            set
            {
                this.limitField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public MappingBehavior MappingBehavior
        {
            get
            {
                return this.mappingBehaviorField;
            }
            set
            {
                this.mappingBehaviorField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString OtherResourceType
        {
            get
            {
                return this.otherResourceTypeField;
            }
            set
            {
                this.otherResourceTypeField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString Parent
        {
            get
            {
                return this.parentField;
            }
            set
            {
                this.parentField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString PoolID
        {
            get
            {
                return this.poolIDField;
            }
            set
            {
                this.poolIDField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimUnsignedLong Reservation
        {
            get
            {
                return this.reservationField;
            }
            set
            {
                this.reservationField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString ResourceSubType
        {
            get
            {
                return this.resourceSubTypeField;
            }
            set
            {
                this.resourceSubTypeField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public ResourceType ResourceType
        {
            get
            {
                return this.resourceTypeField;
            }
            set
            {
                this.resourceTypeField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimUnsignedLong VirtualQuantity
        {
            get
            {
                return this.virtualQuantityField;
            }
            set
            {
                this.virtualQuantityField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString VirtualQuantityUnits
        {
            get
            {
                return this.virtualQuantityUnitsField;
            }
            set
            {
                this.virtualQuantityUnitsField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimUnsignedInt Weight
        {
            get
            {
                return this.weightField;
            }
            set
            {
                this.weightField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;
            }
            set
            {
                this.anyField = value;
            }
        }

        /// <remarks/>
        [XmlAnyAttributeAttribute]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }


    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData")]
    public partial class ConsumerVisibility : cimUnsignedShort
    {
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData")]
    public partial class MappingBehavior : cimUnsignedShort
    {
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData")]
    public partial class ResourceType : cimUnsignedShort
    {
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class VirtualHardwareSection_Type : Section_Type
    {

        private VSSD_Type systemField;

        private RASD_Type[] itemField;

        private string transportField;

        private System.Xml.XmlElement[] anyField;

        public VirtualHardwareSection_Type()
        {
            this.transportField = "";
        }

        /// <remarks/>
        public VSSD_Type System
        {
            get
            {
                return this.systemField;
            }
            set
            {
                this.systemField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute("Item")]
        public RASD_Type[] Item
        {
            get
            {
                return this.itemField;
            }
            set
            {
                this.itemField = value;
            }
        }

        /// <remarks/>
        [XmlAttributeAttribute(Form = XmlSchemaForm.Qualified)]
        [DefaultValueAttribute("")]
        public string transport
        {
            get
            {
                return this.transportField;
            }
            set
            {
                this.transportField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;



            }
            set
            {
                this.anyField = value;

            }
        }

        #region CITRIX EXTENSION
        private Xen_ConfigurationSettingData_Type[] virtualSystemOtherConfigurationDataField;

        [XmlElementAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
        public Xen_ConfigurationSettingData_Type[] VirtualSystemOtherConfigurationData
        {
            get
            {
                return virtualSystemOtherConfigurationDataField;
            }
            set
            {
                virtualSystemOtherConfigurationDataField = value;
            }
        }
        #endregion
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class VSSD_Type : CIM_VirtualSystemSettingData_Type
    {

        private System.Xml.XmlAttribute[] anyAttr1Field;

        
        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr1
        {
            get
            {
                return this.anyAttr1Field;
            }
            set
            {
                this.anyAttr1Field = value;
            }
        }
    }

    /// <remarks/>
    [System.Xml.Serialization.XmlIncludeAttribute(typeof(VSSD_Type))]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_VirtualSystemSettingData")]
    public partial class CIM_VirtualSystemSettingData_Type
    {

        private AutomaticRecoveryAction automaticRecoveryActionField;

        private AutomaticShutdownAction automaticShutdownActionField;

        private AutomaticStartupAction automaticStartupActionField;

        private cimDateTime automaticStartupActionDelayField;

        private cimUnsignedShort automaticStartupActionSequenceNumberField;

        private Caption captionField;

        private cimString configurationDataRootField;

        private cimString configurationFileField;

        private cimString configurationIDField;

        private cimDateTime creationTimeField;

        private cimString descriptionField;

        private cimString elementNameField;

        private cimString instanceIDField;

        private cimString logDataRootField;

        private cimString[] notesField;

        private cimString recoveryFileField;

        private cimString snapshotDataRootField;

        private cimString suspendDataRootField;

        private cimString swapFileDataRootField;

        private cimString virtualSystemIdentifierField;

        private cimString virtualSystemTypeField;

        private System.Xml.XmlElement[] anyField;

        private System.Xml.XmlAttribute[] anyAttrField;

        /// <remarks/>
        [XmlElementAttribute]
        public AutomaticRecoveryAction AutomaticRecoveryAction
        {
            get
            {
                return this.automaticRecoveryActionField;
            }
            set
            {
                this.automaticRecoveryActionField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public AutomaticShutdownAction AutomaticShutdownAction
        {
            get
            {
                return this.automaticShutdownActionField;
            }
            set
            {
                this.automaticShutdownActionField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public AutomaticStartupAction AutomaticStartupAction
        {
            get
            {
                return this.automaticStartupActionField;
            }
            set
            {
                this.automaticStartupActionField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimDateTime AutomaticStartupActionDelay
        {
            get
            {
                return this.automaticStartupActionDelayField;
            }
            set
            {
                this.automaticStartupActionDelayField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimUnsignedShort AutomaticStartupActionSequenceNumber
        {
            get
            {
                return this.automaticStartupActionSequenceNumberField;
            }
            set
            {
                this.automaticStartupActionSequenceNumberField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public Caption Caption
        {
            get
            {
                return this.captionField;
            }
            set
            {
                this.captionField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString ConfigurationDataRoot
        {
            get
            {
                return this.configurationDataRootField;
            }
            set
            {
                this.configurationDataRootField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString ConfigurationFile
        {
            get
            {
                return this.configurationFileField;
            }
            set
            {
                this.configurationFileField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString ConfigurationID
        {
            get
            {
                return this.configurationIDField;
            }
            set
            {
                this.configurationIDField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimDateTime CreationTime
        {
            get
            {
                return this.creationTimeField;
            }
            set
            {
                this.creationTimeField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString Description
        {
            get
            {
                return this.descriptionField;
            }
            set
            {
                this.descriptionField = value;
            }
        }

        /// <remarks/>
        public cimString ElementName
        {
            get
            {
                return this.elementNameField;
            }
            set
            {
                this.elementNameField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString InstanceID
        {
            get
            {
                return this.instanceIDField;
            }
            set
            {
                this.instanceIDField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString LogDataRoot
        {
            get
            {
                return this.logDataRootField;
            }
            set
            {
                this.logDataRootField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute("Notes")]
        public cimString[] Notes
        {
            get
            {
                return this.notesField;
            }
            set
            {
                this.notesField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString RecoveryFile
        {
            get
            {
                return this.recoveryFileField;
            }
            set
            {
                this.recoveryFileField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString SnapshotDataRoot
        {
            get
            {
                return this.snapshotDataRootField;
            }
            set
            {
                this.snapshotDataRootField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString SuspendDataRoot
        {
            get
            {
                return this.suspendDataRootField;
            }
            set
            {
                this.suspendDataRootField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString SwapFileDataRoot
        {
            get
            {
                return this.swapFileDataRootField;
            }
            set
            {
                this.swapFileDataRootField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString VirtualSystemIdentifier
        {
            get
            {
                return this.virtualSystemIdentifierField;
            }
            set
            {
                this.virtualSystemIdentifierField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public cimString VirtualSystemType
        {
            get
            {
                return this.virtualSystemTypeField;
            }
            set
            {
                this.virtualSystemTypeField = value;
            }
        }

        /// <remarks/>
        [XmlElementAttribute]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;
            }
            set
            {
                this.anyField = value;
            }
        }

        /// <remarks/>
        [XmlAnyAttributeAttribute]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_VirtualSystemSettingData")]
    public partial class AutomaticRecoveryAction : cimAnySimpleType
    {
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_VirtualSystemSettingData")]
    public partial class AutomaticShutdownAction : cimAnySimpleType
    {
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_VirtualSystemSettingData")]
    public partial class AutomaticStartupAction : cimAnySimpleType
    {
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_VirtualSystemSettingData")]
    public partial class Caption : cimString
    {
        #region CITRIX ADDED
        public Caption() : base() { }
        public Caption(string value) : base(value) { }
        #endregion

    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_VirtualSystemSettingData")]
    public partial class ChangeableType : cimUnsignedShort
    {
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class EulaSection_Type : Section_Type
    {

        private Msg_Type licenseField;

        private System.Xml.XmlElement[] anyField;

        /// <remarks/>
        public Msg_Type License
        {
            get
            {
                return this.licenseField;
            }
            set
            {
                this.licenseField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;


            }
            set
            {
                this.anyField = value;

            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class OperatingSystemSection_Type : Section_Type
    {

        private Msg_Type descriptionField;

        private System.Xml.XmlElement[] anyField;

        private ushort idField;

        private string versionField;

        /// <remarks/>
        public Msg_Type Description
        {
            get
            {
                return this.descriptionField;
            }
            set
            {
                this.descriptionField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public ushort id
        {
            get
            {
                return this.idField;
            }
            set
            {
                this.idField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string version
        {
            get
            {
                return this.versionField;
            }
            set
            {
                this.versionField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;


            }
            set
            {
                this.anyField = value;

            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class DiskSection_Type : Section_Type
    {

        private VirtualDiskDesc_Type[] diskField;

        private System.Xml.XmlElement[] anyField;

        /// <remarks/>
        [System.Xml.Serialization.XmlElementAttribute("Disk")]
        public VirtualDiskDesc_Type[] Disk
        {
            get
            {
                return this.diskField;
            }
            set
            {
                this.diskField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;


            }
            set
            {
                this.anyField = value;

            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class VirtualDiskDesc_Type
    {
        private System.Xml.XmlElement[] anyField;

        private string diskIdField;

        private string fileRefField;

        private string capacityField;

        private string capacityAllocationUnitsField;

        private string formatField;

        private long populatedSizeField;

        private bool populatedSizeFieldSpecified;

        private string parentRefField;

        private System.Xml.XmlAttribute[] anyAttrField;

        #region ADDED BY CITRIX
        private bool isBootableField;

        [XmlAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
        [DefaultValueAttribute(false)]
        public bool isBootable
        {
            get { return isBootableField; }
            set { isBootableField = value; }
        }
        #endregion

        public VirtualDiskDesc_Type()
        {
            this.capacityAllocationUnitsField = "byte";
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;
            }
            set
            {
                this.anyField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string diskId
        {
            get
            {
                return this.diskIdField;
            }
            set
            {
                this.diskIdField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string fileRef
        {
            get
            {
                return this.fileRefField;
            }
            set
            {
                this.fileRefField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string capacity
        {
            get
            {
                return this.capacityField;
            }
            set
            {
                this.capacityField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute("byte")]
        public string capacityAllocationUnits
        {
            get
            {
                return this.capacityAllocationUnitsField;
            }
            set
            {
                this.capacityAllocationUnitsField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string format
        {
            get
            {
                return this.formatField;
            }
            set
            {
                this.formatField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public long populatedSize
        {
            get
            {
                return this.populatedSizeField;
            }
            set
            {
                this.populatedSizeField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool populatedSizeSpecified
        {
            get
            {
                return this.populatedSizeFieldSpecified;
            }
            set
            {
                this.populatedSizeFieldSpecified = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string parentRef
        {
            get
            {
                return this.parentRefField;
            }
            set
            {
                this.parentRefField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    [System.Xml.Serialization.XmlRootAttribute("NetworkSection", Namespace = "http://schemas.dmtf.org/ovf/envelope/1", IsNullable = false)]
    public partial class NetworkSection_Type : Section_Type
    {

        private NetworkSection_TypeNetwork[] networkField;

        private System.Xml.XmlElement[] anyField;

        /// <remarks/>
        [System.Xml.Serialization.XmlElementAttribute("Network")]
        public NetworkSection_TypeNetwork[] Network
        {
            get
            {
                return this.networkField;
            }
            set
            {
                this.networkField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;


            }
            set
            {
                this.anyField = value;

            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class NetworkSection_TypeNetwork
    {

        private Msg_Type descriptionField;

        private string nameField;

        private System.Xml.XmlAttribute[] anyAttrField;

        /// <remarks/>
        public Msg_Type Description
        {
            get
            {
                return this.descriptionField;
            }
            set
            {
                this.descriptionField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string name
        {
            get
            {
                return this.nameField;
            }
            set
            {
                this.nameField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    [System.Xml.Serialization.XmlRootAttribute("ProductSection", Namespace = "http://schemas.dmtf.org/ovf/envelope/1", IsNullable = false)]
    public partial class ProductSection_Type : Section_Type
    {

        private Msg_Type productField;

        private Msg_Type vendorField;

        private cimString versionField;

        private cimString fullVersionField;

        private cimString productUrlField;

        private cimString vendorUrlField;

        private cimString appUrlField;

        private ProductSection_TypeIcon[] iconField;

        private object[] itemsField;

        private System.Xml.XmlElement[] anyField;

        private string classField;

        private string instanceField;

        public ProductSection_Type()
        {
            this.classField = "";
            this.instanceField = "";
        }

        /// <remarks/>
        public Msg_Type Product
        {
            get
            {
                return this.productField;
            }
            set
            {
                this.productField = value;
            }
        }

        /// <remarks/>
        public Msg_Type Vendor
        {
            get
            {
                return this.vendorField;
            }
            set
            {
                this.vendorField = value;
            }
        }

        /// <remarks/>
        public cimString Version
        {
            get
            {
                return this.versionField;
            }
            set
            {
                this.versionField = value;
            }
        }

        /// <remarks/>
        public cimString FullVersion
        {
            get
            {
                return this.fullVersionField;
            }
            set
            {
                this.fullVersionField = value;
            }
        }

        /// <remarks/>
        public cimString ProductUrl
        {
            get
            {
                return this.productUrlField;
            }
            set
            {
                this.productUrlField = value;
            }
        }

        /// <remarks/>
        public cimString VendorUrl
        {
            get
            {
                return this.vendorUrlField;
            }
            set
            {
                this.vendorUrlField = value;
            }
        }

        /// <remarks/>
        public cimString AppUrl
        {
            get
            {
                return this.appUrlField;
            }
            set
            {
                this.appUrlField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlElementAttribute("Icon")]
        public ProductSection_TypeIcon[] Icon
        {
            get
            {
                return this.iconField;
            }
            set
            {
                this.iconField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlElementAttribute("Category", typeof(Msg_Type))]
        [System.Xml.Serialization.XmlElementAttribute("Property", typeof(ProductSection_TypeProperty))]
        public object[] Items
        {
            get
            {
                return this.itemsField;
            }
            set
            {
                this.itemsField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;
            }
            set
            {
                this.anyField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute("")]
        public string @class
        {
            get
            {
                return this.classField;
            }
            set
            {
                this.classField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute("")]
        public string instance
        {
            get
            {
                return this.instanceField;
            }
            set
            {
                this.instanceField = value;
            }
        }

    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class ProductSection_TypeIcon
    {

        private ushort heightField;

        private bool heightFieldSpecified;

        private ushort widthField;

        private bool widthFieldSpecified;

        private string mimeTypeField;

        private string fileRefField;

        private System.Xml.XmlAttribute[] anyAttrField;

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public ushort height
        {
            get
            {
                return this.heightField;
            }
            set
            {
                this.heightField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool heightSpecified
        {
            get
            {
                return this.heightFieldSpecified;
            }
            set
            {
                this.heightFieldSpecified = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public ushort width
        {
            get
            {
                return this.widthField;
            }
            set
            {
                this.widthField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool widthSpecified
        {
            get
            {
                return this.widthFieldSpecified;
            }
            set
            {
                this.widthFieldSpecified = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string mimeType
        {
            get
            {
                return this.mimeTypeField;
            }
            set
            {
                this.mimeTypeField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string fileRef
        {
            get
            {
                return this.fileRefField;
            }
            set
            {
                this.fileRefField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class ProductSection_TypeProperty
    {

        private Msg_Type labelField;

        private Msg_Type descriptionField;

        private PropertyConfigurationValue_Type[] valueField;

        private string keyField;

        private string typeField;

        private string qualifiersField;

        private bool userConfigurableField;

        private string valueField1;

        private System.Xml.XmlAttribute[] anyAttrField;

        public ProductSection_TypeProperty()
        {
            this.userConfigurableField = false;
            this.valueField1 = "";
        }

        /// <remarks/>
        public Msg_Type Label
        {
            get
            {
                return this.labelField;
            }
            set
            {
                this.labelField = value;
            }
        }

        /// <remarks/>
        public Msg_Type Description
        {
            get
            {
                return this.descriptionField;
            }
            set
            {
                this.descriptionField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlElementAttribute("Value")]
        public PropertyConfigurationValue_Type[] Value
        {
            get
            {
                return this.valueField;
            }
            set
            {
                this.valueField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string key
        {
            get
            {
                return this.keyField;
            }
            set
            {
                this.keyField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string type
        {
            get
            {
                return this.typeField;
            }
            set
            {
                this.typeField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string qualifiers
        {
            get
            {
                return this.qualifiersField;
            }
            set
            {
                this.qualifiersField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute(false)]
        public bool userConfigurable
        {
            get
            {
                return this.userConfigurableField;
            }
            set
            {
                this.userConfigurableField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute("")]
        public string value
        {
            get
            {
                return this.valueField1;
            }
            set
            {
                this.valueField1 = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }

        #region CITRIX ADDED
        private string idField;
        [XmlAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
        public string id
        {
            get { return idField; }
            set { idField = value; }
        }
        #endregion

    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    public partial class PropertyConfigurationValue_Type
    {
        private System.Xml.XmlElement[] anyField;

        private string valueField;

        private string configurationField;

        private System.Xml.XmlAttribute[] anyAttrField;

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;
            }
            set
            {
                this.anyField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string value
        {
            get
            {
                return this.valueField;
            }
            set
            {
                this.valueField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        public string configuration
        {
            get
            {
                return this.configurationField;
            }
            set
            {
                this.configurationField = value;
            }
        }

        /// <remarks/>
        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    [System.Xml.Serialization.XmlRootAttribute("VirtualSystemCollection", Namespace = "http://schemas.dmtf.org/ovf/envelope/1", IsNullable = false)]
    public partial class VirtualSystemCollection_Type : Content_Type
    {

        private Content_Type[] items1Field;

        /// <remarks/>
        [System.Xml.Serialization.XmlElementAttribute("Content", typeof(Content_Type))]
        [System.Xml.Serialization.XmlElementAttribute("VirtualSystem", typeof(VirtualSystem_Type))]
        [System.Xml.Serialization.XmlElementAttribute("VirtualSystemCollection", typeof(VirtualSystemCollection_Type))]
        public Content_Type[] Content
        {
            get
            {
                return this.items1Field;
            }
            set
            {
                this.items1Field = value;
            }
        }
    }

    /// <remarks/>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Xsd2Code", "1.0.3177.19956")]
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
    [System.Xml.Serialization.XmlRootAttribute("VirtualSystem", Namespace = "http://schemas.dmtf.org/ovf/envelope/1", IsNullable = false)]
    public partial class VirtualSystem_Type : Content_Type
    {
    }

    #region CITRIX EXTENSION SECTION
    [XmlTypeAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
    public partial class Xen_ConfigurationSettingData_Type
    {
        private Msg_Type infoField;
        private string nameField;
        private cimString valueField;
        private string idField;

        private bool requiredField;
        private bool requiredFieldSpecified;
        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool required
        {
            get
            {
                return this.requiredField;
            }
            set
            {
                this.requiredField = value;
            }
        }
        /// <remarks/>
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool requiredSpecified
        {
            get
            {
                return this.requiredFieldSpecified;
            }
            set
            {
                this.requiredFieldSpecified = value;
            }
        }

        [XmlAttribute]
        public string id
        {
            get { return idField; }
            set { idField = value; }
        }
        [XmlElement("Info")]
        public Msg_Type Info
        {
            get
            {
                return this.infoField;
            }
            set
            {
                this.infoField = value;
            }
        }
        [XmlAttribute]
        public string Name
        {
            get
            {
                return nameField;
            }
            set
            {
                nameField = value;
            }
        }
        [XmlElement]
        public cimString Value
        {
            get
            {
                return valueField;
            }
            set
            {
                valueField = value;
            }
        }
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
    public partial class SecuritySection_Type : Section_Type
    {
        private Security_Type[] securityField;

        [XmlElement("Security", Namespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", Form=XmlSchemaForm.Qualified)]
        public Security_Type[] Security
        {
            get
            {
                return securityField;
            }
            set
            {
                securityField = value;
            }
        }

    }

    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")]
    public partial class Security_Type
    {
        private System.Xml.XmlElement[] anyField;
        private System.Xml.XmlAttribute[] anyAttrField;
        private string idField;
        private string versionField;
        private XENC.ReferenceList referencelistField;
        private XENC.EncryptionMethodType encryptionMethodField;
        private XENC.EncryptedKeyType encryptedKeyField;
        private XENC.EncryptedDataType encryptedDataField;

        [XmlAttribute(Namespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd")]
        public string Id
        {
            get
            {
                return idField;
            }
            set
            {
                idField = value;
            }
        }

        [XmlAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
        public string version
        {
            get { return versionField; }
            set { versionField = value; }
        }

        [XmlElement(Namespace = "http://www.w3.org/2001/04/xmlenc#")]
        public XENC.ReferenceList ReferenceList
        {
            get
            {
                return referencelistField;
            }
            set
            {
                referencelistField = value;
            }
        }

        [XmlElement(Namespace = "http://www.w3.org/2001/04/xmlenc#")]
        public XENC.EncryptionMethodType EncryptionMethod
        {
            get
            {
                return encryptionMethodField;
            }
            set
            {
                encryptionMethodField = value;
            }
        }

        [XmlElement(Namespace = "http://www.w3.org/2001/04/xmlenc#")]
        public XENC.EncryptedKeyType EncryptedKey
        {
            get
            {
                return encryptedKeyField;
            }
            set
            {
                encryptedKeyField = value;
            }
        }

        [XmlElement(Namespace = "http://www.w3.org/2001/04/xmlenc#")]
        public XENC.EncryptedDataType EncryptedData
        {
            get
            {
                return encryptedDataField;
            }
            set
            {
                encryptedDataField = value;
            }
        }

        [System.Xml.Serialization.XmlAnyElementAttribute()]
        public System.Xml.XmlElement[] Any
        {
            get
            {
                return this.anyField;
            }
            set
            {
                this.anyField = value;
            }
        }

        [System.Xml.Serialization.XmlAnyAttributeAttribute()]
        public System.Xml.XmlAttribute[] AnyAttr
        {
            get
            {
                return this.anyAttrField;
            }
            set
            {
                this.anyAttrField = value;
            }
        }

    }

    [DebuggerStepThroughAttribute()]
    [XmlTypeAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
    public partial class Xen_PostInstallOperation_Type
    {
        private string idField;
        private Msg_Type infoField;
        private Xen_PostInstallOperationCommand_Type[] postInstallOperationsField;

        private bool requiredField;
        private bool requiredFieldSpecified;
        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool required
        {
            get
            {
                return this.requiredField;
            }
            set
            {
                this.requiredField = value;
            }
        }
        /// <remarks/>
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool requiredSpecified
        {
            get
            {
                return this.requiredFieldSpecified;
            }
            set
            {
                this.requiredFieldSpecified = value;
            }
        }


        [XmlAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
        public string id
        {
            get
            {
                return idField;
            }
            set
            {
                idField = value;
            }
        }

        [XmlElement(Namespace = "http://schemas.dmtf.org/ovf/envelope/1")]
        public Msg_Type Info
        {
            get
            {
                return infoField;
            }
            set
            {
                infoField = value;
            }
        }

        [XmlElement(ElementName = "PostInstallOperationCommand", Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
        public Xen_PostInstallOperationCommand_Type[] PostInstallOperationCommand
        {
            get
            {
                return postInstallOperationsField;
            }
            set
            {
                postInstallOperationsField = value;
            }
        }
    }

    [DebuggerStepThroughAttribute()]
    [XmlTypeAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
    public partial class Xen_PostInstallOperationCommand_Type
    {
        private string idField;
        private uint orderField;
        private string operationField;
        private string valueFied;

        private bool requiredField;
        private bool requiredFieldSpecified;
        /// <remarks/>
        [System.Xml.Serialization.XmlAttributeAttribute(Form = System.Xml.Schema.XmlSchemaForm.Qualified)]
        [System.ComponentModel.DefaultValueAttribute(true)]
        public bool required
        {
            get
            {
                return this.requiredField;
            }
            set
            {
                this.requiredField = value;
            }
        }
        /// <remarks/>
        [System.Xml.Serialization.XmlIgnoreAttribute()]
        public bool requiredSpecified
        {
            get
            {
                return this.requiredFieldSpecified;
            }
            set
            {
                this.requiredFieldSpecified = value;
            }
        }



        [XmlAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
        public string id
        {
            get
            {
                return idField;
            }
            set
            {
                idField = value;
            }
        }
        [XmlAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
        public uint Order
        {
            get
            {
                return orderField;
            }
            set
            {
                orderField = value;
            }
        }
        [XmlAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
        public string Operation
        {
            get
            {
                return operationField;
            }
            set
            {
                operationField = value;
            }
        }
        [XmlAttribute(Namespace = "http://schemas.citrix.com/ovf/envelope/1")]
        public string Value
        {
            get
            {
                return valueFied;
            }
            set
            {
                valueFied = value;
            }
        }
    }
    #endregion


    #region VMWARE IDENTIFIED
    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.Xml.Serialization.XmlTypeAttribute(Namespace = "http://www.vmware.com/schema/ovf")]
    public partial class IpAssignmentSection_Type : Section_Type
    {
        private string protocolsField;
        private string schemesField;

        [XmlAttribute(Namespace = "http://www.vmware.com/schema/ovf")]
        public string protocols
        {
            get
            {
                return protocolsField;
            }
            set
            {
                protocolsField = value;
            }
        }

        [XmlAttribute(Namespace = "http://www.vmware.com/schema/ovf")]
        public string schemes
        {
            get
            {
                return schemesField;
            }
            set
            {
                schemesField = value;
            }
        }

    }
    #endregion


}
    