/*
 * Copyright (c) Cloud Software Group, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   1) Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *
 *   2) Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following
 *      disclaimer in the documentation and/or other materials
 *      provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

using Newtonsoft.Json;


namespace XenAPI
{
    [JsonConverter(typeof(domain_typeConverter))]
    public enum domain_type
    {
        /// <summary>
        /// HVM; Fully Virtualised
        /// </summary>
        hvm,
        /// <summary>
        /// PV: Paravirtualised
        /// </summary>
        pv,
        /// <summary>
        /// PV inside a PVH container
        /// </summary>
        pv_in_pvh,
        /// <summary>
        /// PVH
        /// </summary>
        pvh,
        /// <summary>
        /// Not specified or unknown domain type
        /// </summary>
        unspecified,
        unknown
    }

    public static class domain_type_helper
    {
        public static string ToString(domain_type x)
        {
            return x.StringOf();
        }
    }

    public static partial class EnumExt
    {
        public static string StringOf(this domain_type x)
        {
            switch (x)
            {
                case domain_type.hvm:
                    return "hvm";
                case domain_type.pv:
                    return "pv";
                case domain_type.pv_in_pvh:
                    return "pv_in_pvh";
                case domain_type.pvh:
                    return "pvh";
                case domain_type.unspecified:
                    return "unspecified";
                default:
                    return "unknown";
            }
        }
    }

    internal class domain_typeConverter : XenEnumConverter
    {
        public override void WriteJson(JsonWriter writer, object value, JsonSerializer serializer)
        {
            writer.WriteValue(((domain_type)value).StringOf());
        }
    }
}
