﻿/* Copyright (c) Cloud Software Group, Inc. 
 * 
 * Redistribution and use in source and binary forms, 
 * with or without modification, are permitted provided 
 * that the following conditions are met: 
 * 
 * *   Redistributions of source code must retain the above 
 *     copyright notice, this list of conditions and the 
 *     following disclaimer. 
 * *   Redistributions in binary form must reproduce the above 
 *     copyright notice, this list of conditions and the 
 *     following disclaimer in the documentation and/or other 
 *     materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */

using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

using XenAdmin;
using XenAdmin.Controls;
using XenAdmin.Controls.MainWindowControls;

namespace XenAdminTests.TreeTests
{
    [TestFixture, Category(TestCategories.UICategoryB)]
    public class MainWindowTreeTestsDefault : MainWindowLauncher_TestFixture
    {
        /// <summary>
        /// Asserts that all nodes matched by the specified Predicate are expanded and the rest are collapsed.
        /// </summary>
        protected void CheckExpandedNodes(Predicate<VirtualTreeNode> match, string assertMessage)
        {
            MWWaitFor(delegate
            {
                foreach (VirtualTreeNode n in MainWindowWrapper.TreeView.AllNodes)
                {
                    if (match(n) && n.Nodes.Count > 0)
                    {
                        if (!n.IsExpanded)
                        {
                            return false;
                        }
                    }
                    else if (n.IsExpanded)
                    {
                        return false;
                    }
                }
                return true;
            }, assertMessage);
        }

        [Test]
        public void TestOrgViewDefaultExpandedNodes()
        {
            ConnectToStateDBs("state1.xml");
            PutInNavigationMode(NavigationPane.NavigationMode.Objects);
            CheckExpandedNodes(n => n.Text == "Objects by Type", "Expanded nodes incorrect.");
        }
    }
}
