/* Copyright (c) Cloud Software Group, Inc. 
 * 
 * Redistribution and use in source and binary forms, 
 * with or without modification, are permitted provided 
 * that the following conditions are met: 
 * 
 * *   Redistributions of source code must retain the above 
 *     copyright notice, this list of conditions and the 
 *     following disclaimer. 
 * *   Redistributions in binary form must reproduce the above 
 *     copyright notice, this list of conditions and the 
 *     following disclaimer in the documentation and/or other 
 *     materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */

/*
 * To create this file, I did the following:
 *
 * Make a directory.
 * Find the Windows forms ActiveX Control Importer tool (AxImp.exe) on your computer.
 * Find the mstscax.dll file for the version of RDP Client you want to use
 * 
 * In PowerShell:
 * 
 * PS> $ax = 'C:\path\to\AxImp.exe'
 * PS> & $ax mstscax.dll /source
 * 
 * Copy the resulting MSTSCLib.dll and AxMSTSCLib.cs into XenAdmin/RDP.
 * 
 * Finally, remove the AssemblyVersion and TypeLibraryTimeStamp attributes from the top of that file.
 */

//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version:4.0.30319.42000
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace AxMSTSCLib {
    
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{a41a4187-5a86-4e26-b40a-856f9035d9cb}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsTscAxNotSafeForScripting : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsTscAx ocx;
        
        private AxMsTscAxNotSafeForScriptingEventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsTscAxNotSafeForScripting() : 
                base("a41a4187-5a86-4e26-b40a-856f9035d9cb") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsTscAxNotSafeForScriptingEventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsTscAx)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    public delegate void IMsTscAxEvents_OnDisconnectedEventHandler(object sender, IMsTscAxEvents_OnDisconnectedEvent e);
    
    public class IMsTscAxEvents_OnDisconnectedEvent {
        
        public int discReason;
        
        public IMsTscAxEvents_OnDisconnectedEvent(int discReason) {
            this.discReason = discReason;
        }
    }
    
    public delegate void IMsTscAxEvents_OnChannelReceivedDataEventHandler(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e);
    
    public class IMsTscAxEvents_OnChannelReceivedDataEvent {
        
        public string chanName;
        
        public string data;
        
        public IMsTscAxEvents_OnChannelReceivedDataEvent(string chanName, string data) {
            this.chanName = chanName;
            this.data = data;
        }
    }
    
    public delegate void IMsTscAxEvents_OnFatalErrorEventHandler(object sender, IMsTscAxEvents_OnFatalErrorEvent e);
    
    public class IMsTscAxEvents_OnFatalErrorEvent {
        
        public int errorCode;
        
        public IMsTscAxEvents_OnFatalErrorEvent(int errorCode) {
            this.errorCode = errorCode;
        }
    }
    
    public delegate void IMsTscAxEvents_OnWarningEventHandler(object sender, IMsTscAxEvents_OnWarningEvent e);
    
    public class IMsTscAxEvents_OnWarningEvent {
        
        public int warningCode;
        
        public IMsTscAxEvents_OnWarningEvent(int warningCode) {
            this.warningCode = warningCode;
        }
    }
    
    public delegate void IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e);
    
    public class IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent {
        
        public int width;
        
        public int height;
        
        public IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
    
    public delegate void IMsTscAxEvents_OnConfirmCloseEventHandler(object sender, IMsTscAxEvents_OnConfirmCloseEvent e);
    
    public class IMsTscAxEvents_OnConfirmCloseEvent {
        
        public bool pfAllowClose;
        
        public IMsTscAxEvents_OnConfirmCloseEvent() {
        }
    }
    
    public delegate void IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e);
    
    public class IMsTscAxEvents_OnReceivedTSPublicKeyEvent {
        
        public string publicKey;
        
        public bool pfContinueLogon;
        
        public IMsTscAxEvents_OnReceivedTSPublicKeyEvent(string publicKey) {
            this.publicKey = publicKey;
        }
    }
    
    public delegate void IMsTscAxEvents_OnAutoReconnectingEventHandler(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e);
    
    public class IMsTscAxEvents_OnAutoReconnectingEvent {
        
        public int disconnectReason;
        
        public int attemptCount;
        
        public MSTSCLib.AutoReconnectContinueState pArcContinueStatus;
        
        public IMsTscAxEvents_OnAutoReconnectingEvent(int disconnectReason, int attemptCount) {
            this.disconnectReason = disconnectReason;
            this.attemptCount = attemptCount;
        }
    }
    
    public delegate void IMsTscAxEvents_OnRemoteProgramResultEventHandler(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e);
    
    public class IMsTscAxEvents_OnRemoteProgramResultEvent {
        
        public string bstrRemoteProgram;
        
        public MSTSCLib.RemoteProgramResult lError;
        
        public bool vbIsExecutable;
        
        public IMsTscAxEvents_OnRemoteProgramResultEvent(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            this.bstrRemoteProgram = bstrRemoteProgram;
            this.lError = lError;
            this.vbIsExecutable = vbIsExecutable;
        }
    }
    
    public delegate void IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e);
    
    public class IMsTscAxEvents_OnRemoteProgramDisplayedEvent {
        
        public bool vbDisplayed;
        
        public uint uDisplayInformation;
        
        public IMsTscAxEvents_OnRemoteProgramDisplayedEvent(bool vbDisplayed, uint uDisplayInformation) {
            this.vbDisplayed = vbDisplayed;
            this.uDisplayInformation = uDisplayInformation;
        }
    }
    
    public delegate void IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e);
    
    public class IMsTscAxEvents_OnRemoteWindowDisplayedEvent {
        
        public bool vbDisplayed;
        
        public MSTSCLib._RemotableHandle hwnd;
        
        public MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute;
        
        public IMsTscAxEvents_OnRemoteWindowDisplayedEvent(bool vbDisplayed, MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            this.vbDisplayed = vbDisplayed;
            this.hwnd = hwnd;
            this.windowAttribute = windowAttribute;
        }
    }
    
    public delegate void IMsTscAxEvents_OnLogonErrorEventHandler(object sender, IMsTscAxEvents_OnLogonErrorEvent e);
    
    public class IMsTscAxEvents_OnLogonErrorEvent {
        
        public int lError;
        
        public IMsTscAxEvents_OnLogonErrorEvent(int lError) {
            this.lError = lError;
        }
    }
    
    public delegate void IMsTscAxEvents_OnFocusReleasedEventHandler(object sender, IMsTscAxEvents_OnFocusReleasedEvent e);
    
    public class IMsTscAxEvents_OnFocusReleasedEvent {
        
        public int iDirection;
        
        public IMsTscAxEvents_OnFocusReleasedEvent(int iDirection) {
            this.iDirection = iDirection;
        }
    }
    
    public delegate void IMsTscAxEvents_OnUserNameAcquiredEventHandler(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e);
    
    public class IMsTscAxEvents_OnUserNameAcquiredEvent {
        
        public string bstrUserName;
        
        public IMsTscAxEvents_OnUserNameAcquiredEvent(string bstrUserName) {
            this.bstrUserName = bstrUserName;
        }
    }
    
    public delegate void IMsTscAxEvents_OnMouseInputModeChangedEventHandler(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e);
    
    public class IMsTscAxEvents_OnMouseInputModeChangedEvent {
        
        public bool fMouseModeRelative;
        
        public IMsTscAxEvents_OnMouseInputModeChangedEvent(bool fMouseModeRelative) {
            this.fMouseModeRelative = fMouseModeRelative;
        }
    }
    
    public delegate void IMsTscAxEvents_OnServiceMessageReceivedEventHandler(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e);
    
    public class IMsTscAxEvents_OnServiceMessageReceivedEvent {
        
        public string serviceMessage;
        
        public IMsTscAxEvents_OnServiceMessageReceivedEvent(string serviceMessage) {
            this.serviceMessage = serviceMessage;
        }
    }
    
    public delegate void IMsTscAxEvents_OnNetworkStatusChangedEventHandler(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e);
    
    public class IMsTscAxEvents_OnNetworkStatusChangedEvent {
        
        public uint qualityLevel;
        
        public int bandwidth;
        
        public int rtt;
        
        public IMsTscAxEvents_OnNetworkStatusChangedEvent(uint qualityLevel, int bandwidth, int rtt) {
            this.qualityLevel = qualityLevel;
            this.bandwidth = bandwidth;
            this.rtt = rtt;
        }
    }
    
    public delegate void IMsTscAxEvents_OnAutoReconnecting2EventHandler(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e);
    
    public class IMsTscAxEvents_OnAutoReconnecting2Event {
        
        public int disconnectReason;
        
        public bool networkAvailable;
        
        public int attemptCount;
        
        public int maxAttemptCount;
        
        public IMsTscAxEvents_OnAutoReconnecting2Event(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            this.disconnectReason = disconnectReason;
            this.networkAvailable = networkAvailable;
            this.attemptCount = attemptCount;
            this.maxAttemptCount = maxAttemptCount;
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsTscAxNotSafeForScriptingEventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsTscAxNotSafeForScripting parent;
        
        public AxMsTscAxNotSafeForScriptingEventMulticaster(AxMsTscAxNotSafeForScripting parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{7cacbd7b-0d99-468f-ac33-22e495c0afe5}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClientNotSafeForScripting : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient ocx;
        
        private AxMsRdpClientNotSafeForScriptingEventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClientNotSafeForScripting() : 
                base("7cacbd7b-0d99-468f-ac33-22e495c0afe5") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClientNotSafeForScriptingEventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClientNotSafeForScriptingEventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClientNotSafeForScripting parent;
        
        public AxMsRdpClientNotSafeForScriptingEventMulticaster(AxMsRdpClientNotSafeForScripting parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{3523c2fb-4031-44e4-9a3b-f1e94986ee7f}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient2NotSafeForScripting : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient2 ocx;
        
        private AxMsRdpClient2NotSafeForScriptingEventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient2NotSafeForScripting() : 
                base("3523c2fb-4031-44e4-9a3b-f1e94986ee7f") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient2NotSafeForScriptingEventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient2)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient2NotSafeForScriptingEventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient2NotSafeForScripting parent;
        
        public AxMsRdpClient2NotSafeForScriptingEventMulticaster(AxMsRdpClient2NotSafeForScripting parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{9059f30f-4eb1-4bd2-9fdc-36f43a218f4a}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient2 : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient2 ocx;
        
        private AxMsRdpClient2EventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient2() : 
                base("9059f30f-4eb1-4bd2-9fdc-36f43a218f4a") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient2EventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient2)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient2EventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient2 parent;
        
        public AxMsRdpClient2EventMulticaster(AxMsRdpClient2 parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{971127bb-259f-48c2-bd75-5f97a3331551}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient2a : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient2 ocx;
        
        private AxMsRdpClient2aEventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient2a() : 
                base("971127bb-259f-48c2-bd75-5f97a3331551") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient2aEventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient2)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient2aEventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient2a parent;
        
        public AxMsRdpClient2aEventMulticaster(AxMsRdpClient2a parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{ace575fd-1fcf-4074-9401-ebab990fa9de}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient3NotSafeForScripting : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient3 ocx;
        
        private AxMsRdpClient3NotSafeForScriptingEventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient3NotSafeForScripting() : 
                base("ace575fd-1fcf-4074-9401-ebab990fa9de") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient3NotSafeForScriptingEventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient3)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient3NotSafeForScriptingEventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient3NotSafeForScripting parent;
        
        public AxMsRdpClient3NotSafeForScriptingEventMulticaster(AxMsRdpClient3NotSafeForScripting parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{7584c670-2274-4efb-b00b-d6aaba6d3850}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient3 : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient3 ocx;
        
        private AxMsRdpClient3EventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient3() : 
                base("7584c670-2274-4efb-b00b-d6aaba6d3850") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient3EventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient3)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient3EventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient3 parent;
        
        public AxMsRdpClient3EventMulticaster(AxMsRdpClient3 parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{6a6f4b83-45c5-4ca9-bdd9-0d81c12295e4}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient3a : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient3 ocx;
        
        private AxMsRdpClient3aEventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient3a() : 
                base("6a6f4b83-45c5-4ca9-bdd9-0d81c12295e4") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient3aEventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient3)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient3aEventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient3a parent;
        
        public AxMsRdpClient3aEventMulticaster(AxMsRdpClient3a parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{6ae29350-321b-42be-bbe5-12fb5270c0de}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient4NotSafeForScripting : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient4 ocx;
        
        private AxMsRdpClient4NotSafeForScriptingEventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient4NotSafeForScripting() : 
                base("6ae29350-321b-42be-bbe5-12fb5270c0de") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(400)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings4 AdvancedSettings5 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings5", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings5;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient4NotSafeForScriptingEventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient4)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient4NotSafeForScriptingEventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient4NotSafeForScripting parent;
        
        public AxMsRdpClient4NotSafeForScriptingEventMulticaster(AxMsRdpClient4NotSafeForScripting parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{4edcb26c-d24c-4e72-af07-b576699ac0de}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient4 : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient4 ocx;
        
        private AxMsRdpClient4EventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient4() : 
                base("4edcb26c-d24c-4e72-af07-b576699ac0de") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(400)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings4 AdvancedSettings5 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings5", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings5;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient4EventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient4)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient4EventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient4 parent;
        
        public AxMsRdpClient4EventMulticaster(AxMsRdpClient4 parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{54ce37e0-9834-41ae-9896-4dab69dc022b}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient4a : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient4 ocx;
        
        private AxMsRdpClient4aEventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient4a() : 
                base("54ce37e0-9834-41ae-9896-4dab69dc022b") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(400)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings4 AdvancedSettings5 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings5", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings5;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient4aEventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient4)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient4aEventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient4a parent;
        
        public AxMsRdpClient4aEventMulticaster(AxMsRdpClient4a parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{4eb2f086-c818-447e-b32c-c51ce2b30d31}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient5NotSafeForScripting : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient5 ocx;
        
        private AxMsRdpClient5NotSafeForScriptingEventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient5NotSafeForScripting() : 
                base("4eb2f086-c818-447e-b32c-c51ce2b30d31") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(400)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings4 AdvancedSettings5 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings5", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings5;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(500)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings TransportSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(502)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings5 AdvancedSettings6 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings6", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings6;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(504)]
        public virtual MSTSCLib.ITSRemoteProgram RemoteProgram {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(505)]
        public virtual MSTSCLib.IMsRdpClientShell MsRdpClientShell {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("MsRdpClientShell", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.MsRdpClientShell;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        public virtual string GetErrorDescription(uint disconnectReason, uint extendedDisconnectReason) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetErrorDescription", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetErrorDescription(disconnectReason, extendedDisconnectReason)));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient5NotSafeForScriptingEventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient5)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient5NotSafeForScriptingEventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient5NotSafeForScripting parent;
        
        public AxMsRdpClient5NotSafeForScriptingEventMulticaster(AxMsRdpClient5NotSafeForScripting parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{4eb89ff4-7f78-4a0f-8b8d-2bf02e94e4b2}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient5 : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient5 ocx;
        
        private AxMsRdpClient5EventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient5() : 
                base("4eb89ff4-7f78-4a0f-8b8d-2bf02e94e4b2") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(400)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings4 AdvancedSettings5 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings5", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings5;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(500)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings TransportSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(502)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings5 AdvancedSettings6 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings6", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings6;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(504)]
        public virtual MSTSCLib.ITSRemoteProgram RemoteProgram {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(505)]
        public virtual MSTSCLib.IMsRdpClientShell MsRdpClientShell {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("MsRdpClientShell", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.MsRdpClientShell;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        public virtual string GetErrorDescription(uint disconnectReason, uint extendedDisconnectReason) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetErrorDescription", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetErrorDescription(disconnectReason, extendedDisconnectReason)));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient5EventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient5)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient5EventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient5 parent;
        
        public AxMsRdpClient5EventMulticaster(AxMsRdpClient5 parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{d2ea46a7-c2bf-426b-af24-e19c44456399}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient6NotSafeForScripting : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient6 ocx;
        
        private AxMsRdpClient6NotSafeForScriptingEventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient6NotSafeForScripting() : 
                base("d2ea46a7-c2bf-426b-af24-e19c44456399") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(400)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings4 AdvancedSettings5 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings5", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings5;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(500)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings TransportSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(502)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings5 AdvancedSettings6 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings6", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings6;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(504)]
        public virtual MSTSCLib.ITSRemoteProgram RemoteProgram {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(505)]
        public virtual MSTSCLib.IMsRdpClientShell MsRdpClientShell {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("MsRdpClientShell", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.MsRdpClientShell;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(507)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings6 AdvancedSettings7 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings7", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings7;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(506)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings2 TransportSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings2;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        public virtual string GetErrorDescription(uint disconnectReason, uint extendedDisconnectReason) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetErrorDescription", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetErrorDescription(disconnectReason, extendedDisconnectReason)));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient6NotSafeForScriptingEventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient6)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient6NotSafeForScriptingEventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient6NotSafeForScripting parent;
        
        public AxMsRdpClient6NotSafeForScriptingEventMulticaster(AxMsRdpClient6NotSafeForScripting parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{7390f3d8-0439-4c05-91e3-cf5cb290c3d0}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient6 : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient6 ocx;
        
        private AxMsRdpClient6EventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient6() : 
                base("7390f3d8-0439-4c05-91e3-cf5cb290c3d0") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(400)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings4 AdvancedSettings5 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings5", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings5;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(500)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings TransportSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(502)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings5 AdvancedSettings6 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings6", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings6;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(504)]
        public virtual MSTSCLib.ITSRemoteProgram RemoteProgram {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(505)]
        public virtual MSTSCLib.IMsRdpClientShell MsRdpClientShell {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("MsRdpClientShell", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.MsRdpClientShell;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(507)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings6 AdvancedSettings7 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings7", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings7;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(506)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings2 TransportSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings2;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        public virtual string GetErrorDescription(uint disconnectReason, uint extendedDisconnectReason) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetErrorDescription", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetErrorDescription(disconnectReason, extendedDisconnectReason)));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient6EventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient6)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient6EventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient6 parent;
        
        public AxMsRdpClient6EventMulticaster(AxMsRdpClient6 parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{54d38bf7-b1ef-4479-9674-1bd6ea465258}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient7NotSafeForScripting : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient7 ocx;
        
        private AxMsRdpClient7NotSafeForScriptingEventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient7NotSafeForScripting() : 
                base("54d38bf7-b1ef-4479-9674-1bd6ea465258") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(400)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings4 AdvancedSettings5 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings5", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings5;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(500)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings TransportSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(502)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings5 AdvancedSettings6 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings6", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings6;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(504)]
        public virtual MSTSCLib.ITSRemoteProgram RemoteProgram {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(505)]
        public virtual MSTSCLib.IMsRdpClientShell MsRdpClientShell {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("MsRdpClientShell", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.MsRdpClientShell;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(507)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings6 AdvancedSettings7 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings7", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings7;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(506)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings2 TransportSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(600)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings7 AdvancedSettings8 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings8", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings8;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(601)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings3 TransportSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings3;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(603)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings2 SecuredSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings3;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(604)]
        public virtual MSTSCLib.ITSRemoteProgram2 RemoteProgram2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram2;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        public virtual string GetErrorDescription(uint disconnectReason, uint extendedDisconnectReason) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetErrorDescription", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetErrorDescription(disconnectReason, extendedDisconnectReason)));
            return returnValue;
        }
        
        public virtual string GetStatusText(uint statusCode) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetStatusText(statusCode)));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient7NotSafeForScriptingEventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient7)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient7NotSafeForScriptingEventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient7NotSafeForScripting parent;
        
        public AxMsRdpClient7NotSafeForScriptingEventMulticaster(AxMsRdpClient7NotSafeForScripting parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{a9d7038d-b5ed-472e-9c47-94bea90a5910}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient7 : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient7 ocx;
        
        private AxMsRdpClient7EventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient7() : 
                base("a9d7038d-b5ed-472e-9c47-94bea90a5910") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(400)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings4 AdvancedSettings5 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings5", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings5;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(500)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings TransportSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(502)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings5 AdvancedSettings6 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings6", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings6;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(504)]
        public virtual MSTSCLib.ITSRemoteProgram RemoteProgram {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(505)]
        public virtual MSTSCLib.IMsRdpClientShell MsRdpClientShell {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("MsRdpClientShell", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.MsRdpClientShell;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(507)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings6 AdvancedSettings7 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings7", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings7;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(506)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings2 TransportSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(600)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings7 AdvancedSettings8 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings8", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings8;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(601)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings3 TransportSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings3;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(603)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings2 SecuredSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings3;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(604)]
        public virtual MSTSCLib.ITSRemoteProgram2 RemoteProgram2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram2;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        public virtual string GetErrorDescription(uint disconnectReason, uint extendedDisconnectReason) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetErrorDescription", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetErrorDescription(disconnectReason, extendedDisconnectReason)));
            return returnValue;
        }
        
        public virtual string GetStatusText(uint statusCode) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetStatusText(statusCode)));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient7EventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient7)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient7EventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient7 parent;
        
        public AxMsRdpClient7EventMulticaster(AxMsRdpClient7 parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{a3bc03a0-041d-42e3-ad22-882b7865c9c5}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient8NotSafeForScripting : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient8 ocx;
        
        private AxMsRdpClient8NotSafeForScriptingEventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient8NotSafeForScripting() : 
                base("a3bc03a0-041d-42e3-ad22-882b7865c9c5") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(400)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings4 AdvancedSettings5 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings5", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings5;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(500)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings TransportSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(502)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings5 AdvancedSettings6 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings6", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings6;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(504)]
        public virtual MSTSCLib.ITSRemoteProgram RemoteProgram {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(505)]
        public virtual MSTSCLib.IMsRdpClientShell MsRdpClientShell {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("MsRdpClientShell", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.MsRdpClientShell;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(507)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings6 AdvancedSettings7 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings7", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings7;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(506)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings2 TransportSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(600)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings7 AdvancedSettings8 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings8", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings8;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(601)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings3 TransportSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings3;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(603)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings2 SecuredSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings3;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(604)]
        public virtual MSTSCLib.ITSRemoteProgram2 RemoteProgram2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(701)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings8 AdvancedSettings9 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings9", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings9;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        public virtual string GetErrorDescription(uint disconnectReason, uint extendedDisconnectReason) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetErrorDescription", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetErrorDescription(disconnectReason, extendedDisconnectReason)));
            return returnValue;
        }
        
        public virtual string GetStatusText(uint statusCode) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetStatusText(statusCode)));
            return returnValue;
        }
        
        public virtual void SendRemoteAction(MSTSCLib.RemoteSessionActionType actionType) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendRemoteAction", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendRemoteAction(actionType);
        }
        
        public virtual MSTSCLib.ControlReconnectStatus Reconnect(uint ulWidth, uint ulHeight) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Reconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlReconnectStatus returnValue = ((MSTSCLib.ControlReconnectStatus)(this.ocx.Reconnect(ulWidth, ulHeight)));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient8NotSafeForScriptingEventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient8)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient8NotSafeForScriptingEventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient8NotSafeForScripting parent;
        
        public AxMsRdpClient8NotSafeForScriptingEventMulticaster(AxMsRdpClient8NotSafeForScripting parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{5f681803-2900-4c43-a1cc-cf405404a676}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient8 : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient8 ocx;
        
        private AxMsRdpClient8EventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient8() : 
                base("5f681803-2900-4c43-a1cc-cf405404a676") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(400)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings4 AdvancedSettings5 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings5", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings5;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(500)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings TransportSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(502)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings5 AdvancedSettings6 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings6", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings6;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(504)]
        public virtual MSTSCLib.ITSRemoteProgram RemoteProgram {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(505)]
        public virtual MSTSCLib.IMsRdpClientShell MsRdpClientShell {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("MsRdpClientShell", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.MsRdpClientShell;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(507)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings6 AdvancedSettings7 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings7", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings7;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(506)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings2 TransportSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(600)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings7 AdvancedSettings8 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings8", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings8;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(601)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings3 TransportSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings3;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(603)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings2 SecuredSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings3;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(604)]
        public virtual MSTSCLib.ITSRemoteProgram2 RemoteProgram2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(701)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings8 AdvancedSettings9 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings9", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings9;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        public virtual string GetErrorDescription(uint disconnectReason, uint extendedDisconnectReason) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetErrorDescription", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetErrorDescription(disconnectReason, extendedDisconnectReason)));
            return returnValue;
        }
        
        public virtual string GetStatusText(uint statusCode) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetStatusText(statusCode)));
            return returnValue;
        }
        
        public virtual void SendRemoteAction(MSTSCLib.RemoteSessionActionType actionType) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendRemoteAction", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendRemoteAction(actionType);
        }
        
        public virtual MSTSCLib.ControlReconnectStatus Reconnect(uint ulWidth, uint ulHeight) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Reconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlReconnectStatus returnValue = ((MSTSCLib.ControlReconnectStatus)(this.ocx.Reconnect(ulWidth, ulHeight)));
            return returnValue;
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient8EventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient8)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient8EventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient8 parent;
        
        public AxMsRdpClient8EventMulticaster(AxMsRdpClient8 parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{8b918b82-7985-4c24-89df-c33ad2bbfbcd}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient9NotSafeForScripting : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient9 ocx;
        
        private AxMsRdpClient9NotSafeForScriptingEventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient9NotSafeForScripting() : 
                base("8b918b82-7985-4c24-89df-c33ad2bbfbcd") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(400)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings4 AdvancedSettings5 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings5", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings5;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(500)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings TransportSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(502)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings5 AdvancedSettings6 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings6", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings6;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(504)]
        public virtual MSTSCLib.ITSRemoteProgram RemoteProgram {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(505)]
        public virtual MSTSCLib.IMsRdpClientShell MsRdpClientShell {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("MsRdpClientShell", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.MsRdpClientShell;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(507)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings6 AdvancedSettings7 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings7", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings7;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(506)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings2 TransportSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(600)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings7 AdvancedSettings8 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings8", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings8;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(601)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings3 TransportSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings3;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(603)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings2 SecuredSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings3;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(604)]
        public virtual MSTSCLib.ITSRemoteProgram2 RemoteProgram2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(701)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings8 AdvancedSettings9 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings9", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings9;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(800)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings4 TransportSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings4;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        public virtual string GetErrorDescription(uint disconnectReason, uint extendedDisconnectReason) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetErrorDescription", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetErrorDescription(disconnectReason, extendedDisconnectReason)));
            return returnValue;
        }
        
        public virtual string GetStatusText(uint statusCode) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetStatusText(statusCode)));
            return returnValue;
        }
        
        public virtual void SendRemoteAction(MSTSCLib.RemoteSessionActionType actionType) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendRemoteAction", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendRemoteAction(actionType);
        }
        
        public virtual MSTSCLib.ControlReconnectStatus Reconnect(uint ulWidth, uint ulHeight) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Reconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlReconnectStatus returnValue = ((MSTSCLib.ControlReconnectStatus)(this.ocx.Reconnect(ulWidth, ulHeight)));
            return returnValue;
        }
        
        public virtual void SyncSessionDisplaySettings() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SyncSessionDisplaySettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SyncSessionDisplaySettings();
        }
        
        public virtual void UpdateSessionDisplaySettings(uint ulDesktopWidth, uint ulDesktopHeight, uint ulPhysicalWidth, uint ulPhysicalHeight, uint ulOrientation, uint ulDesktopScaleFactor, uint ulDeviceScaleFactor) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UpdateSessionDisplaySettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.UpdateSessionDisplaySettings(ulDesktopWidth, ulDesktopHeight, ulPhysicalWidth, ulPhysicalHeight, ulOrientation, ulDesktopScaleFactor, ulDeviceScaleFactor);
        }
        
        public virtual void attachEvent(string eventName, object callback) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("attachEvent", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.attachEvent(eventName, callback);
        }
        
        public virtual void detachEvent(string eventName, object callback) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("detachEvent", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.detachEvent(eventName, callback);
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient9NotSafeForScriptingEventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient9)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient9NotSafeForScriptingEventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient9NotSafeForScripting parent;
        
        public AxMsRdpClient9NotSafeForScriptingEventMulticaster(AxMsRdpClient9NotSafeForScripting parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{301b94ba-5d25-4a12-bffe-3b6e7a616585}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient9 : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient9 ocx;
        
        private AxMsRdpClient9EventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient9() : 
                base("301b94ba-5d25-4a12-bffe-3b6e7a616585") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(21)]
        public virtual string Version {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Version", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Version;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(22)]
        public virtual int SecuredSettingsEnabled {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettingsEnabled", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettingsEnabled;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(97)]
        public virtual MSTSCLib.IMsTscSecuredSettings SecuredSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(98)]
        public virtual MSTSCLib.IMsTscAdvancedSettings AdvancedSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(99)]
        public virtual MSTSCLib.IMsTscDebug Debugger {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Debugger", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Debugger;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(100)]
        public virtual int ColorDepth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ColorDepth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ColorDepth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ColorDepth = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(101)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings AdvancedSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(102)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings SecuredSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings2;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(103)]
        public virtual MSTSCLib.ExtendedDisconnectReasonCode ExtendedDisconnectReason {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ExtendedDisconnectReason", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ExtendedDisconnectReason;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(104)]
        public virtual bool FullScreen {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.FullScreen;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreen", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreen = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(200)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings2 AdvancedSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings3;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(201)]
        public virtual string ConnectedStatusText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectedStatusText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectedStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectedStatusText = value;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(300)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings3 AdvancedSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings4;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(400)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings4 AdvancedSettings5 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings5", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings5;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(500)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings TransportSettings {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(502)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings5 AdvancedSettings6 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings6", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings6;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(504)]
        public virtual MSTSCLib.ITSRemoteProgram RemoteProgram {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(505)]
        public virtual MSTSCLib.IMsRdpClientShell MsRdpClientShell {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("MsRdpClientShell", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.MsRdpClientShell;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(507)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings6 AdvancedSettings7 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings7", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings7;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(506)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings2 TransportSettings2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(600)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings7 AdvancedSettings8 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings8", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings8;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(601)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings3 TransportSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings3;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(603)]
        public virtual MSTSCLib.IMsRdpClientSecuredSettings2 SecuredSettings3 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SecuredSettings3", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.SecuredSettings3;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(604)]
        public virtual MSTSCLib.ITSRemoteProgram2 RemoteProgram2 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RemoteProgram2", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.RemoteProgram2;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(701)]
        public virtual MSTSCLib.IMsRdpClientAdvancedSettings8 AdvancedSettings9 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("AdvancedSettings9", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.AdvancedSettings9;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(800)]
        public virtual MSTSCLib.IMsRdpClientTransportSettings4 TransportSettings4 {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("TransportSettings4", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.TransportSettings4;
            }
        }
        
        public event System.EventHandler OnConnecting;
        
        public event System.EventHandler OnConnected;
        
        public event System.EventHandler OnLoginComplete;
        
        public event IMsTscAxEvents_OnDisconnectedEventHandler OnDisconnected;
        
        public event System.EventHandler OnEnterFullScreenMode;
        
        public event System.EventHandler OnLeaveFullScreenMode;
        
        public event IMsTscAxEvents_OnChannelReceivedDataEventHandler OnChannelReceivedData;
        
        public event System.EventHandler OnRequestGoFullScreen;
        
        public event System.EventHandler OnRequestLeaveFullScreen;
        
        public event IMsTscAxEvents_OnFatalErrorEventHandler OnFatalError;
        
        public event IMsTscAxEvents_OnWarningEventHandler OnWarning;
        
        public event IMsTscAxEvents_OnRemoteDesktopSizeChangeEventHandler OnRemoteDesktopSizeChange;
        
        public event System.EventHandler OnIdleTimeoutNotification;
        
        public event System.EventHandler OnRequestContainerMinimize;
        
        public event IMsTscAxEvents_OnConfirmCloseEventHandler OnConfirmClose;
        
        public event IMsTscAxEvents_OnReceivedTSPublicKeyEventHandler OnReceivedTSPublicKey;
        
        public event IMsTscAxEvents_OnAutoReconnectingEventHandler OnAutoReconnecting;
        
        public event System.EventHandler OnAuthenticationWarningDisplayed;
        
        public event System.EventHandler OnAuthenticationWarningDismissed;
        
        public event IMsTscAxEvents_OnRemoteProgramResultEventHandler OnRemoteProgramResult;
        
        public event IMsTscAxEvents_OnRemoteProgramDisplayedEventHandler OnRemoteProgramDisplayed;
        
        public event IMsTscAxEvents_OnRemoteWindowDisplayedEventHandler OnRemoteWindowDisplayed;
        
        public event IMsTscAxEvents_OnLogonErrorEventHandler OnLogonError;
        
        public event IMsTscAxEvents_OnFocusReleasedEventHandler OnFocusReleased;
        
        public event IMsTscAxEvents_OnUserNameAcquiredEventHandler OnUserNameAcquired;
        
        public event IMsTscAxEvents_OnMouseInputModeChangedEventHandler OnMouseInputModeChanged;
        
        public event IMsTscAxEvents_OnServiceMessageReceivedEventHandler OnServiceMessageReceived;
        
        public event System.EventHandler OnConnectionBarPullDown;
        
        public event IMsTscAxEvents_OnNetworkStatusChangedEventHandler OnNetworkStatusChanged;
        
        public event System.EventHandler OnDevicesButtonPressed;
        
        public event System.EventHandler OnAutoReconnected;
        
        public event IMsTscAxEvents_OnAutoReconnecting2EventHandler OnAutoReconnecting2;
        
        public virtual void Connect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Connect();
        }
        
        public virtual void Disconnect() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Disconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.Disconnect();
        }
        
        public virtual void CreateVirtualChannels(string newVal) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CreateVirtualChannels", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.CreateVirtualChannels(newVal);
        }
        
        public virtual void SendOnVirtualChannel(string chanName, string chanData) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendOnVirtualChannel", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendOnVirtualChannel(chanName, chanData);
        }
        
        public virtual void SetVirtualChannelOptions(string chanName, int chanOptions) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SetVirtualChannelOptions(chanName, chanOptions);
        }
        
        public virtual int GetVirtualChannelOptions(string chanName) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetVirtualChannelOptions", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            int returnValue = ((int)(this.ocx.GetVirtualChannelOptions(chanName)));
            return returnValue;
        }
        
        public virtual MSTSCLib.ControlCloseStatus RequestClose() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("RequestClose", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlCloseStatus returnValue = ((MSTSCLib.ControlCloseStatus)(this.ocx.RequestClose()));
            return returnValue;
        }
        
        public virtual string GetErrorDescription(uint disconnectReason, uint extendedDisconnectReason) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetErrorDescription", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetErrorDescription(disconnectReason, extendedDisconnectReason)));
            return returnValue;
        }
        
        public virtual string GetStatusText(uint statusCode) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("GetStatusText", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            string returnValue = ((string)(this.ocx.GetStatusText(statusCode)));
            return returnValue;
        }
        
        public virtual void SendRemoteAction(MSTSCLib.RemoteSessionActionType actionType) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SendRemoteAction", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SendRemoteAction(actionType);
        }
        
        public virtual MSTSCLib.ControlReconnectStatus Reconnect(uint ulWidth, uint ulHeight) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Reconnect", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            MSTSCLib.ControlReconnectStatus returnValue = ((MSTSCLib.ControlReconnectStatus)(this.ocx.Reconnect(ulWidth, ulHeight)));
            return returnValue;
        }
        
        public virtual void SyncSessionDisplaySettings() {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("SyncSessionDisplaySettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.SyncSessionDisplaySettings();
        }
        
        public virtual void UpdateSessionDisplaySettings(uint ulDesktopWidth, uint ulDesktopHeight, uint ulPhysicalWidth, uint ulPhysicalHeight, uint ulOrientation, uint ulDesktopScaleFactor, uint ulDeviceScaleFactor) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UpdateSessionDisplaySettings", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.UpdateSessionDisplaySettings(ulDesktopWidth, ulDesktopHeight, ulPhysicalWidth, ulPhysicalHeight, ulOrientation, ulDesktopScaleFactor, ulDeviceScaleFactor);
        }
        
        public virtual void attachEvent(string eventName, object callback) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("attachEvent", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.attachEvent(eventName, callback);
        }
        
        public virtual void detachEvent(string eventName, object callback) {
            if ((this.ocx == null)) {
                throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("detachEvent", System.Windows.Forms.AxHost.ActiveXInvokeKind.MethodInvoke);
            }
            this.ocx.detachEvent(eventName, callback);
        }
        
        protected override void CreateSink() {
            try {
                this.eventMulticaster = new AxMsRdpClient9EventMulticaster(this);
                this.cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ocx, this.eventMulticaster, typeof(MSTSCLib.IMsTscAxEvents));
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void DetachSink() {
            try {
                this.cookie.Disconnect();
            }
            catch (System.Exception ) {
            }
        }
        
        protected override void AttachInterfaces() {
            try {
                this.ocx = ((MSTSCLib.IMsRdpClient9)(this.GetOcx()));
            }
            catch (System.Exception ) {
            }
        }
        
        internal void RaiseOnOnConnecting(object sender, System.EventArgs e) {
            if ((this.OnConnecting != null)) {
                this.OnConnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnConnected(object sender, System.EventArgs e) {
            if ((this.OnConnected != null)) {
                this.OnConnected(sender, e);
            }
        }
        
        internal void RaiseOnOnLoginComplete(object sender, System.EventArgs e) {
            if ((this.OnLoginComplete != null)) {
                this.OnLoginComplete(sender, e);
            }
        }
        
        internal void RaiseOnOnDisconnected(object sender, IMsTscAxEvents_OnDisconnectedEvent e) {
            if ((this.OnDisconnected != null)) {
                this.OnDisconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnEnterFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnEnterFullScreenMode != null)) {
                this.OnEnterFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnLeaveFullScreenMode(object sender, System.EventArgs e) {
            if ((this.OnLeaveFullScreenMode != null)) {
                this.OnLeaveFullScreenMode(sender, e);
            }
        }
        
        internal void RaiseOnOnChannelReceivedData(object sender, IMsTscAxEvents_OnChannelReceivedDataEvent e) {
            if ((this.OnChannelReceivedData != null)) {
                this.OnChannelReceivedData(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestGoFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestGoFullScreen != null)) {
                this.OnRequestGoFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestLeaveFullScreen(object sender, System.EventArgs e) {
            if ((this.OnRequestLeaveFullScreen != null)) {
                this.OnRequestLeaveFullScreen(sender, e);
            }
        }
        
        internal void RaiseOnOnFatalError(object sender, IMsTscAxEvents_OnFatalErrorEvent e) {
            if ((this.OnFatalError != null)) {
                this.OnFatalError(sender, e);
            }
        }
        
        internal void RaiseOnOnWarning(object sender, IMsTscAxEvents_OnWarningEvent e) {
            if ((this.OnWarning != null)) {
                this.OnWarning(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteDesktopSizeChange(object sender, IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent e) {
            if ((this.OnRemoteDesktopSizeChange != null)) {
                this.OnRemoteDesktopSizeChange(sender, e);
            }
        }
        
        internal void RaiseOnOnIdleTimeoutNotification(object sender, System.EventArgs e) {
            if ((this.OnIdleTimeoutNotification != null)) {
                this.OnIdleTimeoutNotification(sender, e);
            }
        }
        
        internal void RaiseOnOnRequestContainerMinimize(object sender, System.EventArgs e) {
            if ((this.OnRequestContainerMinimize != null)) {
                this.OnRequestContainerMinimize(sender, e);
            }
        }
        
        internal void RaiseOnOnConfirmClose(object sender, IMsTscAxEvents_OnConfirmCloseEvent e) {
            if ((this.OnConfirmClose != null)) {
                this.OnConfirmClose(sender, e);
            }
        }
        
        internal void RaiseOnOnReceivedTSPublicKey(object sender, IMsTscAxEvents_OnReceivedTSPublicKeyEvent e) {
            if ((this.OnReceivedTSPublicKey != null)) {
                this.OnReceivedTSPublicKey(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting(object sender, IMsTscAxEvents_OnAutoReconnectingEvent e) {
            if ((this.OnAutoReconnecting != null)) {
                this.OnAutoReconnecting(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDisplayed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDisplayed != null)) {
                this.OnAuthenticationWarningDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnAuthenticationWarningDismissed(object sender, System.EventArgs e) {
            if ((this.OnAuthenticationWarningDismissed != null)) {
                this.OnAuthenticationWarningDismissed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramResult(object sender, IMsTscAxEvents_OnRemoteProgramResultEvent e) {
            if ((this.OnRemoteProgramResult != null)) {
                this.OnRemoteProgramResult(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteProgramDisplayed(object sender, IMsTscAxEvents_OnRemoteProgramDisplayedEvent e) {
            if ((this.OnRemoteProgramDisplayed != null)) {
                this.OnRemoteProgramDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnRemoteWindowDisplayed(object sender, IMsTscAxEvents_OnRemoteWindowDisplayedEvent e) {
            if ((this.OnRemoteWindowDisplayed != null)) {
                this.OnRemoteWindowDisplayed(sender, e);
            }
        }
        
        internal void RaiseOnOnLogonError(object sender, IMsTscAxEvents_OnLogonErrorEvent e) {
            if ((this.OnLogonError != null)) {
                this.OnLogonError(sender, e);
            }
        }
        
        internal void RaiseOnOnFocusReleased(object sender, IMsTscAxEvents_OnFocusReleasedEvent e) {
            if ((this.OnFocusReleased != null)) {
                this.OnFocusReleased(sender, e);
            }
        }
        
        internal void RaiseOnOnUserNameAcquired(object sender, IMsTscAxEvents_OnUserNameAcquiredEvent e) {
            if ((this.OnUserNameAcquired != null)) {
                this.OnUserNameAcquired(sender, e);
            }
        }
        
        internal void RaiseOnOnMouseInputModeChanged(object sender, IMsTscAxEvents_OnMouseInputModeChangedEvent e) {
            if ((this.OnMouseInputModeChanged != null)) {
                this.OnMouseInputModeChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnServiceMessageReceived(object sender, IMsTscAxEvents_OnServiceMessageReceivedEvent e) {
            if ((this.OnServiceMessageReceived != null)) {
                this.OnServiceMessageReceived(sender, e);
            }
        }
        
        internal void RaiseOnOnConnectionBarPullDown(object sender, System.EventArgs e) {
            if ((this.OnConnectionBarPullDown != null)) {
                this.OnConnectionBarPullDown(sender, e);
            }
        }
        
        internal void RaiseOnOnNetworkStatusChanged(object sender, IMsTscAxEvents_OnNetworkStatusChangedEvent e) {
            if ((this.OnNetworkStatusChanged != null)) {
                this.OnNetworkStatusChanged(sender, e);
            }
        }
        
        internal void RaiseOnOnDevicesButtonPressed(object sender, System.EventArgs e) {
            if ((this.OnDevicesButtonPressed != null)) {
                this.OnDevicesButtonPressed(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnected(object sender, System.EventArgs e) {
            if ((this.OnAutoReconnected != null)) {
                this.OnAutoReconnected(sender, e);
            }
        }
        
        internal void RaiseOnOnAutoReconnecting2(object sender, IMsTscAxEvents_OnAutoReconnecting2Event e) {
            if ((this.OnAutoReconnecting2 != null)) {
                this.OnAutoReconnecting2(sender, e);
            }
        }
    }
    
    [System.Runtime.InteropServices.ClassInterface(System.Runtime.InteropServices.ClassInterfaceType.None)]
    public class AxMsRdpClient9EventMulticaster : MSTSCLib.IMsTscAxEvents {
        
        private AxMsRdpClient9 parent;
        
        public AxMsRdpClient9EventMulticaster(AxMsRdpClient9 parent) {
            this.parent = parent;
        }
        
        public virtual void OnConnecting() {
            System.EventArgs onconnectingEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnecting(this.parent, onconnectingEvent);
        }
        
        public virtual void OnConnected() {
            System.EventArgs onconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnected(this.parent, onconnectedEvent);
        }
        
        public virtual void OnLoginComplete() {
            System.EventArgs onlogincompleteEvent = new System.EventArgs();
            this.parent.RaiseOnOnLoginComplete(this.parent, onlogincompleteEvent);
        }
        
        public virtual void OnDisconnected(int discReason) {
            IMsTscAxEvents_OnDisconnectedEvent ondisconnectedEvent = new IMsTscAxEvents_OnDisconnectedEvent(discReason);
            this.parent.RaiseOnOnDisconnected(this.parent, ondisconnectedEvent);
        }
        
        public virtual void OnEnterFullScreenMode() {
            System.EventArgs onenterfullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnEnterFullScreenMode(this.parent, onenterfullscreenmodeEvent);
        }
        
        public virtual void OnLeaveFullScreenMode() {
            System.EventArgs onleavefullscreenmodeEvent = new System.EventArgs();
            this.parent.RaiseOnOnLeaveFullScreenMode(this.parent, onleavefullscreenmodeEvent);
        }
        
        public virtual void OnChannelReceivedData(string chanName, string data) {
            IMsTscAxEvents_OnChannelReceivedDataEvent onchannelreceiveddataEvent = new IMsTscAxEvents_OnChannelReceivedDataEvent(chanName, data);
            this.parent.RaiseOnOnChannelReceivedData(this.parent, onchannelreceiveddataEvent);
        }
        
        public virtual void OnRequestGoFullScreen() {
            System.EventArgs onrequestgofullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestGoFullScreen(this.parent, onrequestgofullscreenEvent);
        }
        
        public virtual void OnRequestLeaveFullScreen() {
            System.EventArgs onrequestleavefullscreenEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestLeaveFullScreen(this.parent, onrequestleavefullscreenEvent);
        }
        
        public virtual void OnFatalError(int errorCode) {
            IMsTscAxEvents_OnFatalErrorEvent onfatalerrorEvent = new IMsTscAxEvents_OnFatalErrorEvent(errorCode);
            this.parent.RaiseOnOnFatalError(this.parent, onfatalerrorEvent);
        }
        
        public virtual void OnWarning(int warningCode) {
            IMsTscAxEvents_OnWarningEvent onwarningEvent = new IMsTscAxEvents_OnWarningEvent(warningCode);
            this.parent.RaiseOnOnWarning(this.parent, onwarningEvent);
        }
        
        public virtual void OnRemoteDesktopSizeChange(int width, int height) {
            IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent onremotedesktopsizechangeEvent = new IMsTscAxEvents_OnRemoteDesktopSizeChangeEvent(width, height);
            this.parent.RaiseOnOnRemoteDesktopSizeChange(this.parent, onremotedesktopsizechangeEvent);
        }
        
        public virtual void OnIdleTimeoutNotification() {
            System.EventArgs onidletimeoutnotificationEvent = new System.EventArgs();
            this.parent.RaiseOnOnIdleTimeoutNotification(this.parent, onidletimeoutnotificationEvent);
        }
        
        public virtual void OnRequestContainerMinimize() {
            System.EventArgs onrequestcontainerminimizeEvent = new System.EventArgs();
            this.parent.RaiseOnOnRequestContainerMinimize(this.parent, onrequestcontainerminimizeEvent);
        }
        
        public virtual void OnConfirmClose(out bool pfAllowClose) {
            IMsTscAxEvents_OnConfirmCloseEvent onconfirmcloseEvent = new IMsTscAxEvents_OnConfirmCloseEvent();
            this.parent.RaiseOnOnConfirmClose(this.parent, onconfirmcloseEvent);
            pfAllowClose = onconfirmcloseEvent.pfAllowClose;
        }
        
        public virtual void OnReceivedTSPublicKey(string publicKey, out bool pfContinueLogon) {
            IMsTscAxEvents_OnReceivedTSPublicKeyEvent onreceivedtspublickeyEvent = new IMsTscAxEvents_OnReceivedTSPublicKeyEvent(publicKey);
            this.parent.RaiseOnOnReceivedTSPublicKey(this.parent, onreceivedtspublickeyEvent);
            pfContinueLogon = onreceivedtspublickeyEvent.pfContinueLogon;
        }
        
        public virtual void OnAutoReconnecting(int disconnectReason, int attemptCount, out MSTSCLib.AutoReconnectContinueState pArcContinueStatus) {
            IMsTscAxEvents_OnAutoReconnectingEvent onautoreconnectingEvent = new IMsTscAxEvents_OnAutoReconnectingEvent(disconnectReason, attemptCount);
            this.parent.RaiseOnOnAutoReconnecting(this.parent, onautoreconnectingEvent);
            pArcContinueStatus = onautoreconnectingEvent.pArcContinueStatus;
        }
        
        public virtual void OnAuthenticationWarningDisplayed() {
            System.EventArgs onauthenticationwarningdisplayedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDisplayed(this.parent, onauthenticationwarningdisplayedEvent);
        }
        
        public virtual void OnAuthenticationWarningDismissed() {
            System.EventArgs onauthenticationwarningdismissedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAuthenticationWarningDismissed(this.parent, onauthenticationwarningdismissedEvent);
        }
        
        public virtual void OnRemoteProgramResult(string bstrRemoteProgram, MSTSCLib.RemoteProgramResult lError, bool vbIsExecutable) {
            IMsTscAxEvents_OnRemoteProgramResultEvent onremoteprogramresultEvent = new IMsTscAxEvents_OnRemoteProgramResultEvent(bstrRemoteProgram, lError, vbIsExecutable);
            this.parent.RaiseOnOnRemoteProgramResult(this.parent, onremoteprogramresultEvent);
        }
        
        public virtual void OnRemoteProgramDisplayed(bool vbDisplayed, uint uDisplayInformation) {
            IMsTscAxEvents_OnRemoteProgramDisplayedEvent onremoteprogramdisplayedEvent = new IMsTscAxEvents_OnRemoteProgramDisplayedEvent(vbDisplayed, uDisplayInformation);
            this.parent.RaiseOnOnRemoteProgramDisplayed(this.parent, onremoteprogramdisplayedEvent);
        }
        
        public virtual void OnRemoteWindowDisplayed(bool vbDisplayed, ref MSTSCLib._RemotableHandle hwnd, MSTSCLib.RemoteWindowDisplayedAttribute windowAttribute) {
            IMsTscAxEvents_OnRemoteWindowDisplayedEvent onremotewindowdisplayedEvent = new IMsTscAxEvents_OnRemoteWindowDisplayedEvent(vbDisplayed, hwnd, windowAttribute);
            this.parent.RaiseOnOnRemoteWindowDisplayed(this.parent, onremotewindowdisplayedEvent);
            hwnd = onremotewindowdisplayedEvent.hwnd;
        }
        
        public virtual void OnLogonError(int lError) {
            IMsTscAxEvents_OnLogonErrorEvent onlogonerrorEvent = new IMsTscAxEvents_OnLogonErrorEvent(lError);
            this.parent.RaiseOnOnLogonError(this.parent, onlogonerrorEvent);
        }
        
        public virtual void OnFocusReleased(int iDirection) {
            IMsTscAxEvents_OnFocusReleasedEvent onfocusreleasedEvent = new IMsTscAxEvents_OnFocusReleasedEvent(iDirection);
            this.parent.RaiseOnOnFocusReleased(this.parent, onfocusreleasedEvent);
        }
        
        public virtual void OnUserNameAcquired(string bstrUserName) {
            IMsTscAxEvents_OnUserNameAcquiredEvent onusernameacquiredEvent = new IMsTscAxEvents_OnUserNameAcquiredEvent(bstrUserName);
            this.parent.RaiseOnOnUserNameAcquired(this.parent, onusernameacquiredEvent);
        }
        
        public virtual void OnMouseInputModeChanged(bool fMouseModeRelative) {
            IMsTscAxEvents_OnMouseInputModeChangedEvent onmouseinputmodechangedEvent = new IMsTscAxEvents_OnMouseInputModeChangedEvent(fMouseModeRelative);
            this.parent.RaiseOnOnMouseInputModeChanged(this.parent, onmouseinputmodechangedEvent);
        }
        
        public virtual void OnServiceMessageReceived(string serviceMessage) {
            IMsTscAxEvents_OnServiceMessageReceivedEvent onservicemessagereceivedEvent = new IMsTscAxEvents_OnServiceMessageReceivedEvent(serviceMessage);
            this.parent.RaiseOnOnServiceMessageReceived(this.parent, onservicemessagereceivedEvent);
        }
        
        public virtual void OnConnectionBarPullDown() {
            System.EventArgs onconnectionbarpulldownEvent = new System.EventArgs();
            this.parent.RaiseOnOnConnectionBarPullDown(this.parent, onconnectionbarpulldownEvent);
        }
        
        public virtual void OnNetworkStatusChanged(uint qualityLevel, int bandwidth, int rtt) {
            IMsTscAxEvents_OnNetworkStatusChangedEvent onnetworkstatuschangedEvent = new IMsTscAxEvents_OnNetworkStatusChangedEvent(qualityLevel, bandwidth, rtt);
            this.parent.RaiseOnOnNetworkStatusChanged(this.parent, onnetworkstatuschangedEvent);
        }
        
        public virtual void OnDevicesButtonPressed() {
            System.EventArgs ondevicesbuttonpressedEvent = new System.EventArgs();
            this.parent.RaiseOnOnDevicesButtonPressed(this.parent, ondevicesbuttonpressedEvent);
        }
        
        public virtual void OnAutoReconnected() {
            System.EventArgs onautoreconnectedEvent = new System.EventArgs();
            this.parent.RaiseOnOnAutoReconnected(this.parent, onautoreconnectedEvent);
        }
        
        public virtual void OnAutoReconnecting2(int disconnectReason, bool networkAvailable, int attemptCount, int maxAttemptCount) {
            IMsTscAxEvents_OnAutoReconnecting2Event onautoreconnecting2Event = new IMsTscAxEvents_OnAutoReconnecting2Event(disconnectReason, networkAvailable, attemptCount, maxAttemptCount);
            this.parent.RaiseOnOnAutoReconnecting2(this.parent, onautoreconnecting2Event);
        }
    }
    
    [System.Windows.Forms.AxHost.ClsidAttribute("{a0c63c30-f08d-4ab4-907c-34905d770c7d}")]
    [System.ComponentModel.DesignTimeVisibleAttribute(true)]
    [System.ComponentModel.DefaultEvent("OnConnecting")]
    public class AxMsRdpClient10NotSafeForScripting : System.Windows.Forms.AxHost {
        
        private MSTSCLib.IMsRdpClient10 ocx;
        
        private AxMsRdpClient10NotSafeForScriptingEventMulticaster eventMulticaster;
        
        private System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
        
        public AxMsRdpClient10NotSafeForScripting() : 
                base("a0c63c30-f08d-4ab4-907c-34905d770c7d") {
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(1)]
        public virtual string Server {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Server;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Server", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Server = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(2)]
        public virtual string Domain {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Domain;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Domain", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.Domain = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(3)]
        public virtual string UserName {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.UserName;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("UserName", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.UserName = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(4)]
        public virtual string DisconnectedText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DisconnectedText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DisconnectedText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DisconnectedText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(5)]
        public virtual string ConnectingText {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.ConnectingText;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("ConnectingText", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.ConnectingText = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(6)]
        public virtual short Connected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("Connected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.Connected;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(12)]
        public virtual int DesktopWidth {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopWidth;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopWidth", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopWidth = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(13)]
        public virtual int DesktopHeight {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.DesktopHeight;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("DesktopHeight", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.DesktopHeight = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(16)]
        public virtual int StartConnected {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.StartConnected;
            }
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("StartConnected", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.StartConnected = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(17)]
        public virtual int HorizontalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("HorizontalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.HorizontalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(18)]
        public virtual int VerticalScrollBarVisible {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("VerticalScrollBarVisible", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.VerticalScrollBarVisible;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(19)]
        public virtual string FullScreenTitle {
            set {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("FullScreenTitle", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertySet);
                }
                this.ocx.FullScreenTitle = value;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.DesignerSerializationVisibility.Hidden)]
        [System.Runtime.InteropServices.DispIdAttribute(20)]
        public virtual int CipherStrength {
            get {
                if ((this.ocx == null)) {
                    throw new System.Windows.Forms.AxHost.InvalidActiveXStateException("CipherStrength", System.Windows.Forms.AxHost.ActiveXInvokeKind.PropertyGet);
                }
                return this.ocx.CipherStrength;
            }
        }
        
        [System.ComponentModel.DesignerSerializationVisibility(System.ComponentModel.Designe