﻿/* Copyright (c) Cloud Software Group, Inc. 
 * 
 * Redistribution and use in source and binary forms, 
 * with or without modification, are permitted provided 
 * that the following conditions are met: 
 * 
 * *   Redistributions of source code must retain the above 
 *     copyright notice, this list of conditions and the 
 *     following disclaimer. 
 * *   Redistributions in binary form must reproduce the above 
 *     copyright notice, this list of conditions and the 
 *     following disclaimer in the documentation and/or other 
 *     materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */

using System.Windows.Forms;

namespace XenAdmin.Controls.Common
{
    /// <summary>
    /// SplitContainer that draws the contents while moving the splitter
    /// (the normal one draws the contents only when the user releases the mouse)
    /// http://social.msdn.microsoft.com/Forums/en/winforms/thread/8824b4a9-f5d6-4337-b820-dcbf68400820
    /// </summary>
    class SmoothSplitContainer : SplitContainer
    {
        protected override void OnMouseDown(MouseEventArgs e)
        {
            IsSplitterFixed = true;
            base.OnMouseDown(e);
        }

        protected override void OnMouseUp(MouseEventArgs e)
        {
            IsSplitterFixed = false;
            base.OnMouseUp(e);
        }

        protected override void OnMouseMove(MouseEventArgs e)
        {
            if (IsSplitterFixed)
            {
                if (e.Button.Equals(MouseButtons.Left))
                {
                    if (Orientation.Equals(Orientation.Vertical))
                    {
                        if (0 < e.X && e.X < Width)
                            SplitterDistance = e.X;
                    }
                    else
                    {
                        if (0< e.Y && e.Y < Height)
                            SplitterDistance = e.Y;
                    }
                }
                else
                    IsSplitterFixed = false;
            }

            base.OnMouseMove(e);
        }
    }
}
