# -*- rpm-spec -*-

Summary: Virtual Machine Monitoring Scripts
Name: xe-guest-utilities
Version: 10.0.0
Release: 1
License: BSD
Group: Xen
URL: https://www.xenserver.com/
Vendor:  Cloud Software Group, Inc.
Source0: https://code.citrite.net/rest/archive/latest/projects/XSU/repos/xe-guest-utilities/archive?at=v%{version}&format=tar.gz&prefix=%{name}-%{version}#/xe-guest-utilities.tar.gz
Source1: branding.mk
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
BuildRequires: wget branding-xenserver
Obsoletes: xengmond


%description
Scripts for monitoring Virtual Machine.

Writes distribution version information and IP address to XenStore.

%package xenstore
Summary: Virtual Machine XenStore utilities
Group: Xen
%description xenstore
Utilities for interacting with XenStore from with a Xen Virtual Machine

%prep
%autosetup -p1
subst_globals()
{
	%{_usrsrc}/branding/brand-file.py \
		--branding %{_usrsrc}/branding/xenserver/toplevel-branding \
		--branding %{_usrsrc}/branding/xenserver/toplevel-versions \
		--branding %{SOURCE1} \
		$1 > $1.tmp
	mv $1.tmp $1
}
subst_globals mk/xe-linux-distribution
subst_globals mk/xe-linux-distribution.init
subst_globals mk/xen-vcpu-hotplug.rules
subst_globals guestmetric/guestmetric_linux.go
subst_globals LICENSE


%build
rm -rf %{buildroot}
gopath=$(pwd)
gotool=$gopath/gotools
goroot=$gopath/gotools/go
go_tool_name=go1.19.3.linux-386.tar.gz
myproject=$gopath/xe-guest-utilities
mkdir -p $myproject
ls | grep -v xe-guest-utilities | xargs cp -r -t ./xe-guest-utilities
mkdir -p $gotool $gopath/golang.org/x/sys
wget -O $gotool/$go_tool_name https://$YUM0@repo.citrite.net/xs-local-contrib/google/go/$go_tool_name
tar -xzvf $gotool/$go_tool_name -C $gotool --overwrite
wget -O $gopath/golang-sys.tar https://$YUM0@repo.citrite.net/xs-local-contrib/google/golang-sys/golang-sys.tar
tar -xf $gopath/golang-sys.tar -C $gopath/golang.org/x/sys --overwrite
cd $myproject
requireStr=$(grep "require golang.org/x/sys" $myproject/go.mod)
replaceStr=$(echo "$requireStr" | sed 's/require/replace/g')
sed -i "s|$requireStr|$replaceStr => ../golang.org/x/sys\n$requireStr|g" $myproject/go.mod
$goroot/bin/go mod vendor
GOROOT=$goroot GO111MODULE=on $goroot/bin/go build -a -x -ldflags="-s -w" -o $gopath/obj/xe-daemon $myproject/xe-daemon/xe-daemon.go
GOROOT=$goroot GO111MODULE=on $goroot/bin/go build -a -x -ldflags="-s -w" -o $gopath/obj/xenstore $myproject/xenstore/xenstore.go


%install
mkdir -p %{buildroot}/usr/sbin/
mkdir -p %{buildroot}/usr/share/doc/%{name}-%{version}/examples/
mkdir -p %{buildroot}/etc/init.d
mkdir -p %{buildroot}/etc/udev/rules.d
mkdir -p %{buildroot}/usr/lib/systemd/system

cp mk/xe-linux-distribution %{buildroot}/usr/sbin/xe-linux-distribution
chmod 755 %{buildroot}/usr/sbin/xe-linux-distribution

cp mk/xe-linux-distribution.init %{buildroot}/etc/init.d/xe-linux-distribution
chmod 755 %{buildroot}/etc/init.d/xe-linux-distribution

cp obj/xe-daemon %{buildroot}/usr/sbin/xe-daemon
chmod 755 %{buildroot}/usr/sbin/xe-daemon

cp mk/xe-linux-distribution.service %{buildroot}/usr/lib/systemd/system/xe-linux-distribution.service
chmod 644 %{buildroot}/usr/lib/systemd/system/xe-linux-distribution.service

install -d %{buildroot}/usr/bin/
install -m 755 obj/xenstore %{buildroot}/usr/bin/xenstore
ln -s /usr/bin/xenstore %{buildroot}/usr/bin/xenstore-read
ln -s /usr/bin/xenstore %{buildroot}/usr/bin/xenstore-write
ln -s /usr/bin/xenstore %{buildroot}/usr/bin/xenstore-exists
ln -s /usr/bin/xenstore %{buildroot}/usr/bin/xenstore-rm
ln -s /usr/bin/xenstore %{buildroot}/usr/bin/xenstore-list
ln -s /usr/bin/xenstore %{buildroot}/usr/bin/xenstore-ls
ln -s /usr/bin/xenstore %{buildroot}/usr/bin/xenstore-chmod
ln -s /usr/bin/xenstore %{buildroot}/usr/bin/xenstore-watch

cp mk/xen-vcpu-hotplug.rules %{buildroot}/etc/udev/rules.d/z10-xen-vcpu-hotplug.rules

cp LICENSE  %{buildroot}/usr/share/doc/%{name}-%{version}/

mkdir -p %{buildroot}/usr/share/doc/%{name}-xenstore-%{version}
cp LICENSE  %{buildroot}/usr/share/doc/%{name}-xenstore-%{version}/

%clean
rm -rf %{buildroot}

%post
#!/bin/bash
if command -v systemctl >/dev/null 2>&1; then
    xe_install_path=/usr/sbin
    sed -i "s#/usr/share/oem/xs#$xe_install_path#g" /usr/lib/systemd/system/xe-linux-distribution.service
    systemctl enable /usr/lib/systemd/system/xe-linux-distribution.service >/dev/null 2>&1
    systemctl start xe-linux-distribution.service >/dev/null 2>&1
else
    /sbin/chkconfig --add xe-linux-distribution >/dev/null
    [ -n "${EXTERNAL_P2V}" ] || service xe-linux-distribution start >/dev/null 2>&1
fi

eval $(/usr/sbin/xe-linux-distribution)

if [ -d /etc/yum.repos.d ] && [ -n "${os_distro}" ] && [ -n "${os_majorver}" ] ; then
    distro="${os_distro}${os_majorver}x"
    case "${distro}" in
    rhel4x|centos4x)
        if [ -f /etc/yum.repos.d/XenSource.repo ] ; then
            rm -f /etc/yum.repos.d/XenSource.repo # contains deprecated urls
        fi
        ;;
    *) ;;
    esac
fi

%preun
if [ $1 -eq 0 ] ; then
    if command -v systemctl >/dev/null 2>&1; then
        systemctl stop xe-linux-distribution.service >/dev/null 2>&1
        systemctl disable xe-linux-distribution.service >/dev/null 2>&1
    else
        service xe-linux-distribution stop >/dev/null 2>&1
        /sbin/chkconfig --del xe-linux-distribution >/dev/null
    fi
fi

%files
%defattr(-,root,root,-)
/usr/sbin/xe-linux-distribution
/etc/init.d/xe-linux-distribution
/usr/sbin/xe-daemon
/etc/udev/rules.d/z10-xen-vcpu-hotplug.rules
/usr/share/doc/%{name}-%{version}/LICENSE
/usr/lib/systemd/system/xe-linux-distribution.service

%files xenstore
%defattr(-,root,root,-)
/usr/bin/xenstore-*
/usr/bin/xenstore
/usr/share/doc/%{name}-xenstore-%{version}/LICENSE

%changelog
* Mon Jul 25 2022 Gang Ji <gang.ji@citrix.com> - v7.23.0-3
- CP-37375, CP-39822: Build RPM and DEB packages in CentOS 7(replaced planex) docker container

* Thu May 26 2022 Gang Ji <gang.ji@citrix.com> - v7.23.0-2
- CP-39669: Refactor Makefile to add 'rpm' and 'deb' build targets

* Wed Aug 11 2021 Xihuan Yang <xihuan.yang@citrix.com> - v7.23.0-1
- CP-37115: Add support for Rocky Linux 8.4

* Wed Dec 9 2020 Alex Brett <alex.brett@citrix.com> - v7.21.0-1
- CA-349929: Fix handling of /etc/centos-release for CentOS 8.3+

* Tue May 19 2020 Xin Li <xin.li@citrix.com> - v7.20.0-1
- CP-33708: identify gooroom OS

* Sun Apr 26 2020 Gang Ji <gang.ji@citrix.com> - v7.19.0-1
- CP-33374: update LICENSE file

* Fri Apr 24 2020 Gang Ji <gang.ji@citrix.com> - v7.18.0-2
- CP-33374: Move install.sh to Linux Tools build

* Tue Jan 21 2020 Ross Lagerwall <ross.lagerwall@citrix.com> - v7.18.0-1
- CA-333687: Fix boot hang caused by CPU hotplug rule

* Thu Dec 5 2019 Xin Li <xin.li@citrix.com> - v7.17.0-1
- CA-286041: xe-daemon log spam

* Tue Sep 3 2019 Xin Li <xin.li@citrix.com> - v7.16.0-2
- CA-326329: build 64bit deb package

* Thu Aug 15 2019 Xin Li <xin.li@citrix.com> - v7.16.0-1
- CP-31968: implement xenstore-watch for golang guest xenstore

* Mon Jul 29 2019 Xin Li <xin.li@citrix.com> - v7.15.0-1
- CP-31842: implement xenstore-chmod for golang guest xenstore

* Wed Jul 17 2019 Xin Li <xin.li@citrix.com> - v7.14.0-1
- CP-31808: implement xenstore-ls for golang guest xenstore

* Wed Jun 12 2019 Xihuan Yang <xihuan.yang@citrix.com> - v7.13.0-1
- CP-31387: Add support for SUSE enterprise Linux 15 sp1

* Wed May 29 2019 Yang Qian <yang.qian@citrix.com> - v7.12.0-1
- Add security check tool for the project

* Fri Jan 11 2019 Yuan Ren <yuan.ren@citrix.com> - v7.11.0-1
- CP-30014: Add support for SUSE enterprise Linux 15

* Thu Mar 22 2018 Wei Xie <wei.xie@citrix.com> - v7.10.0-1
- CP-24641: Add SRIOV VF Support.

* Mon Aug 14 2017 Deli Zhang <deli.zhang@citrix.com> - 7.9.0-1
- CP-22495: Add support for NeoKylin Linux Security OS 5.0 (Update8) x64.
- CA-261230: Add support NeoKylin 5.0 for alternative version.

* Mon Jun 26 2017 Ming Lu <ming.lu@citrix.com> - 7.7.0-1
- CA-255021: Change format of IP addresses in xenstore

* Thu Jun 08 2017 Wei Xie <wei.xie@citrix.com> - 7.6.0-1
- Add support for Yinhe Kylin 4.0.
- Add support for Linx Linux.

* Thu Jun 1 2017 wei.xie
- CP-22358: Identify Turbo Linux.
- CP-21862: Make guest tools identify RedFlag Linux.

* Wed Apr 26 2017 cheng.zhang
- CA-250696: DDK build number is optional

* Thu Mar 30 2017 cheng.zhang
- CA-247330: Fix collectDisk log spams
- CA-244770: Kylin linux supoort

* Mon Jan 02 2017 citrix.com
- init version for transformer

* Tue Jun 5 2007  <citrix.com>
- Xen monitor scripts

